#!/bin/sh
# *************************************************************************
# This script is used to stop a Managed WebLogic Server
# Usage: stopWebLogic [force] [username] [password] [server-name] [admin-url]
# *************************************************************************

# Default values
SERVER_NAME="MS1"

# Set common environment variables such as WEBLOGIC_CLASSPATH
if [ "$DOMAIN_HOME" == "" ] ; then
   # If the Domain_Home is not found, assume that the setEnv.sh is in the current directory
    if [ -x ./setEnv.sh ] ; then
        . ./setEnv.sh
    else
      echo ./setEnv.sh is not executable or not found.
      exit 1
    fi
else
    if [ -x ${DOMAIN_HOME}/setEnv.sh ] ; then
        . ${DOMAIN_HOME}/setEnv.sh
    else
      echo ${DOMAIN_HOME}/setEnv.sh is not executable or not found.
      exit 1
    fi
fi

if [ "$1" = "force" ] ; then
   FORCE=FORCESHUTDOWN
   shift
else
   FORCE="SHUTDOWN -ignoreExistingSessions"
   shift
fi

# Check for user name and password
if [ "$1" != "" ] ; then
   UIDPWD="-username $1"
   shift
fi

if [ "$1" != "" ] ; then
   UIDPWD="${UIDPWD} -password $1"
   shift
fi

# Check for server name
if [ "$1" != "" ] ; then
   SERVER_NAME="$1"
   shift
fi

# Check for Admin URL
if [ "$1" != "" ] ; then
   ADMIN_URL="$1"
   shift
fi

echo "Stopping Managed Weblogic Server ${SERVER_NAME} ..."
${JAVA_HOME}/bin/java -cp ${WEBLOGIC_CLASSPATH} ${JAVA_OPTIONS} weblogic.Admin -url ${ADMIN_URL} ${UIDPWD} ${FORCE} ${SERVER_NAME}  2>&1
echo "Done"
