# *************************************************************************
# This script is used to stop a cluster of WebLogic Managed Servers
# Usage: stopWebLogic [username] [password] [server-name] [admin-url]
# *************************************************************************

# Default values
CLUSTER1_NAME="ESRCluster1"
CLUSTER2_NAME="ESRCluster2"
CLUSTER3_NAME="ESRCluster3"

# Set common environment variables such as WEBLOGIC_CLASSPATH
if [ "$DOMAIN_HOME" == "" ] ; then
   # If the Domain_Home is not found, assume that the setEnv.sh is in the current directory
    if [ -x ./setEnv.sh ] ; then
        . ./setEnv.sh
    else
      echo ./setEnv.sh is not executable or not found.
      exit 1
    fi
else
    if [ -x ${DOMAIN_HOME}/setEnv.sh ] ; then
        . ${DOMAIN_HOME}/setEnv.sh
    else
      echo ${DOMAIN_HOME}/setEnv.sh is not executable or not found.
      exit 1
    fi
fi

# Check for user name and passowrd
if [ "$1" != "" ] ; then
   UIDPWD="-username $1"
   shift
fi
if [ "$1" != "" ] ; then
   UIDPWD="${UIDPWD} -password $1"
   shift
fi
#Check for server name
if [ "$1" != "" ] ; then
   CLUSTER1_NAME="$1"
   shift
fi

#Check for server name
if [ "$1" != "" ] ; then
   CLUSTER2_NAME="$1"
   shift
fi

#Check for server name
if [ "$1" != "" ] ; then
   CLUSTER3_NAME="$1"
   shift
fi

# Check for Admin URL
if [ "$1" != "" ] ; then
   ADMIN_URL="$1"
   shift
fi

echo "Stopping ${CLUSTER1_NAME} ..."
${JAVA_HOME}/bin/java ${JAVA_VM} ${MEM_ARGS} -cp ${WEBLOGIC_CLASSPATH} weblogic.Admin -url ${ADMIN_URL} ${UIDPWD} STOPCLUSTER -clustername ${CLUSTER1_NAME} 2>&1
echo "Done"

echo "Stopping ${CLUSTER2_NAME} ..."
${JAVA_HOME}/bin/java ${JAVA_VM} ${MEM_ARGS} -cp ${WEBLOGIC_CLASSPATH} weblogic.Admin -url ${ADMIN_URL} ${UIDPWD} STOPCLUSTER -clustername ${CLUSTER2_NAME} 2>&1
echo "Done"

echo "Stopping ${CLUSTER3_NAME} ..."
${JAVA_HOME}/bin/java ${JAVA_VM} ${MEM_ARGS} -cp ${WEBLOGIC_CLASSPATH} weblogic.Admin -url ${ADMIN_URL} ${UIDPWD} STOPCLUSTER -clustername ${CLUSTER3_NAME} 2>&1
echo "Done"
