#!/bin/sh

# WARNING: This file is created by the Configuration Wizard.
# Any changes to this script may be lost when adding extensions to this configuration.

# *************************************************************************
# This script is used to start WebLogic Server for the domain in the
# current working directory.  This script simply sets the SERVER_NAME
# variable and starts server.
#
# To create your own start script for your domain, all you need to set is
# SERVER_NAME, then starts the server.
#
# Other variables that startWLS takes are:
#
# WEBLOGIC_CLASSPATH - the classpath for java programs and weblogic
# PRODUCTION_MODE    - true for production mode servers, false for
#                development mode
# JAVA_OPTIONS - Java command-line options for running the server. (These
#                will be tagged on to the end of the JAVA_VM and MEM_ARGS)
# JAVA_VM      - The java arg specifying the VM to run.  (i.e. -server,
#                -hotspot, etc.)
# MEM_ARGS     - The variable to override the standard memory arguments
#                passed to java
# HOME         - The Home directory of the user running the command
#
# For additional information, refer to the WebLogic Server Administration
# Console Online Help(http://e-docs.bea.com/wls/docs81/ConsoleHelp/startstop.html)
# *************************************************************************

# Set common environment variables such as WEBLOGIC_CLASSPATH
if [ "$DOMAIN_HOME" == "" ] ; then
   # If the Domain_Home is not found, assume that the setEnv.sh is in the current directory
    if [ -x ./setEnv.sh ] ; then
        . ./setEnv.sh
    else
      echo ./setEnv.sh is not executable or not found.
      exit 1
    fi
else
    if [ -x ${DOMAIN_HOME}/setEnv.sh ] ; then
        . ${DOMAIN_HOME}/setEnv.sh
    else
      echo ${DOMAIN_HOME}/setEnv.sh is not executable or not found.
      exit 1
    fi
fi

${JAVA_HOME}/bin/java -Dweblogic.Name=${ADMIN_SERVER_NAME} ${JAVA_VM} ${MEM_ARGS} ${JAVA_OPTIONS} -cp ${WEBLOGIC_CLASSPATH} -Dweblogic.ProductionModeEnabled=${PRODUCTION_MODE} -Djava.security.policy="${WL_HOME}/server/lib/weblogic.policy" weblogic.Server
