#!/bin/sh
# *************************************************************************
# This script is used to start a cluster of WebLogic Managed Servers
# Usage: startNodeManager
# *************************************************************************

CURRENT_DIR=`pwd`

# Set common environment variables such as WEBLOGIC_CLASSPATH
if [ "$DOMAIN_HOME" == "" ] ; then
   # If the Domain_Home is not found, assume that the setEnv.sh is in the current directory
    if [ -x ./setEnv.sh ] ; then
        . ./setEnv.sh
    else
      echo ./setEnv.sh is not executable or not found.
      exit 1
    fi
else
    if [ -x ${DOMAIN_HOME}/setEnv.sh ] ; then
        . ${DOMAIN_HOME}/setEnv.sh
    else
      echo ${DOMAIN_HOME}/setEnv.sh is not executable or not found.
      exit 1
    fi
fi

if [ "$CURRENT_DIR" != "${NODEMGR_HOME}" ] ; then
   echo changing to ${NODEMGR_HOME}
   cd ${NODEMGR_HOME}
fi
echo "Starting WebLogic NodeManager ..."

"${JAVA_HOME}/bin/java" -Dweblogic.Name=${NODEMGR_SERVER_NAME} ${JAVA_VM} ${MEM_ARGS} ${JAVA_OPTIONS} \
   -Djava.security.policy="${WL_HOME}/server/lib/weblogic.policy" \
   -Dweblogic.nodemanager.javaHome="${JAVA_HOME}" \
   -DListenAddress="${NODEMGR_LISTEN_ADDRESS}" -DListenPort="${NODEMGR_LISTEN_PORT}" \
   -cp ${WEBLOGIC_CLASSPATH} \
   weblogic.NodeManager

cd $CURRENT_DIR
