#!/bin/sh
# *************************************************************************
# This script is used to start a Messaging Client for a Weblogic cluster
# Usage: startMessagingClient [S] (for Sender) or [R] (for Receiver)
# *************************************************************************

# Set common environment variables such as WEBLOGIC_CLASSPATH
if [ "$DOMAIN_HOME" == "" ] ; then
   # If the Domain_Home is not found, assume that the setEnv.sh is in the parent directory
    if [ -x ../setEnv.sh ] ; then
        ../setEnv.sh
    else
      echo ../setEnv.sh is not executable or not found.
      exit 1
    fi
else
    if [ -x ${DOMAIN_HOME}/setEnv.sh ] ; then
        . ${DOMAIN_HOME}/setEnv.sh
    else
      echo ${DOMAIN_HOME}/setEnv.sh is not executable or not found.
      exit 1
    fi
fi
MESSAGING_CLIENT_CLASSPATH=${WEBLOGIC_CLASSPATH}:.:./commons-logging.jar:./commons-lang.jar:./framework.jar:./messagingClient.jar


#
# Start JMS Sender
#
startSender()
{
"${JAVA_HOME}/bin/java" -Dweblogic.Name=${NODEMGR_SERVER_NAME} ${JAVA_VM} ${MEM_ARGS} ${JAVA_OPTIONS} \
   -cp ${MESSAGING_CLIENT_CLASSPATH} \
   gov.va.med.esr.vitria.Sender messagingConfig
  exit 0
}

#
# Start JMS Receiver
#
startReceiver()
{
"${JAVA_HOME}/bin/java" -Dweblogic.Name=${NODEMGR_SERVER_NAME} ${JAVA_VM} ${MEM_ARGS} ${JAVA_OPTIONS} \
   -cp ${MESSAGING_CLIENT_CLASSPATH} \
   gov.va.med.esr.vitria.Receiver messagingConfig
  exit 0
}

#
# Display usage
#
showUsage()
{
  echo ""
  echo "==========================================================================================="
  echo " Usage: startMessagingClient [S] (for Sender) or [R] (for Receiver)"
  echo ""
  echo "  where Sender can send Messages to ESR Cluster3"
  echo "      and Receiver can consume JMS messages from ESR Cluster1"
  echo ""
  echo "==========================================================================================="
  echo ""
  exit 1
}

#
# Check input arguments to run the appropriate options
#
if [ ${#} = 0 ]; then
  showUsage
elif [ ${#} = 1 ]; then
  OPTIONS=${1}
  if [ "x${OPTIONS}" = "x" ]; then
    showUsage
  else
    case $OPTIONS in
    S)
      startSender
    ;;
    R)
      startReceiver
    ;;
    *)
      showUsage
    ;;
    esac
  fi
else
  showUsage
fi

