#!/bin/sh
# ****************************************************************************
# This script is used to set up your WLS 8.1 domain environment. User defined
# are set up first then call ${WL_HOME}/common/bin to set WLS environment.
# ****************************************************************************

#
# Only set up common variables if not set in a shell .profile 
#

# Set Production Mode.  When this is set to true, the server starts up in
# production mode.  When set to false, the server starts up in development
# mode.  If it is not set, it will default to false.
if [ "$PRODUCTION_MODE" == "" ] ; then 
   export PRODUCTION_MODE="true"
fi

# Set JAVA_VENDOR to java virtual machine you want to run on server side.
if [ "$JAVA_VENDOR" == "" ] ; then 
   export JAVA_VENDOR="Sun"
fi

# Set JAVA_HOME to java virtual machine you want to run on server side.
if [ "$JAVA_HOME" == "" ] ; then 
   export JAVA_HOME="/usr/java/j2sdk1.4.2_14" 
fi

# Set DOMAIN_HOME to a domain directory on a server
if [ "$DOMAIN_HOME" == "" ] ; then 
   export DOMAIN_HOME="${HOME}/wldomain/ESRDomain"
fi

# Set NODEMGR_HOME to a domain directory on a server
if [ "$NODEMGR_HOME" == "" ] ; then 
   export NODEMGR_HOME="${HOME}/wlnodemanager/ESRNodeManager"
fi

#
# Set up ESR specific environment variables taht are not set 
# in a shell .profile file
#
export APP_NAME="esr"
export DOMAIN_NAME="ESRDomain"
export ADMIN_SERVER_NAME="ESRAdminServer"
export NODEMGR_LISTEN_ADDRESS=`hostname`
export NODEMGR_LISTEN_PORT="5300"
export NODEMGR_SERVER_NAME="NodeManager"
export ADMIN_URL="t3://${HOSTNAME}:7300"
export DEPLOYMENT="${DOMAIN_HOME}/applications/esr.ear"
export CAIP_CONFIG_HOME="ESRDomain"

#
# Call commEnv.sh to set up WLS 8.1 environment variables
#
. "${WL_HOME}/common/bin/commEnv.sh"

#
# Set user.home to a domain home directory then append it 
# a JAVA_OPTIONS variable set in a commonEnv.sh
export JAVA_OPTIONS="${JAVA_OPTIONS} -Duser.home=${DOMAIN_HOME} -DDSKey.store=${CAIP_CONFIG_HOME}/caipService.jks -DmyCaipConfig.xml=${CAIP_CONFIG_HOME}/caipConfig.xml"

