#!/bin/sh
# ******************************************************************************
# This script is used to clean up log files for ESRDomain.  Set the parameters
# first before starting this scripts to remove log files.
#
# DOMAIN_HOME       - The directory in which the ESR domain files are stored
# NODEMGR_HOME      - The directory in which ESR managed servers are started.
# DOMAIN_NAME       - The ESR domain name
# ADMIN_SERVER_NAME - The ESR admin server name
#
# ******************************************************************************

# Set common environment variables such as WEBLOGIC_CLASSPATH
if [ "$DOMAIN_HOME" == "" ] ; then
   # If the Domain_Home is not found, assume that the setEnv.sh is in the current directory
    if [ -x ./setEnv.sh ] ; then
        . ./setEnv.sh
    else
      echo ./setEnv.sh is not executable or not found.
      exit 1
    fi
else
    if [ -x ${DOMAIN_HOME}/setEnv.sh ] ; then
        . ${DOMAIN_HOME}/setEnv.sh
    else
      echo ${DOMAIN_HOME}/setEnv.sh is not executable or not found.
      exit 1
    fi
fi

# Display usage
showUsage()
{
  echo ""
  echo "==========================================================================================="
  echo " Usage: cleanLogs.sh [OPTIONS] where OPTIONS are 1 for ON-LINE, and 2 for OFF-LINE"
  echo ""
  echo " Use ON-LINE option while ESR clusters, admin server, and node managers are running."
  echo " ON-LINE option does the following:"
  echo " - Delete ESR log files"
  echo ""
  echo " Use OFF-LINE option while ESR clusters, admin server, and node managers are NOT running."
  echo " OFF-LINE option does the following:"
  echo " - Delete ESR log files"
  echo " - Delete BEA log files"
  echo " - Delete a managed server directory in which an ESR staging directory resides"
  echo " - Delete a msi-config.xml in a managed server directory"
  echo " - Delete managed server data (*.dat) files"
  echo ""
  echo "==========================================================================================="
  echo ""
  exit 1
}

#
# Delete all BEA and ESR log files.  Also delete deployed application
#
runOffLine()
{
  echo "Archiving all log files before deleting"
  . ${DOMAIN_HOME}/archiveLogs.sh

  echo "Deleting all log files under ESRDomain and admin server directory"
  rm -rf ${DOMAIN_HOME}/*.log* ${DOMAIN_HOME}/NodeManagerClientLogs
  rm -rf ${DOMAIN_HOME}/${ADMIN_SERVER_NAME}/*.log* ${DOMAIN_HOME}/${ADMIN_SERVER_NAME}/*.tlog*
  echo "Completed"

  echo "Deleting msi-config.*, *.dat, applications directory, xmlcache directory"
  echo "and all log files under NodeManagerLogs and managed server directory"
  rm -rf ${NODEMGR_HOME}/msi-config.* ${NODEMGR_HOME}/*.dat ${NODEMGR_HOME}/applications ${NODEMGR_HOME}/xmlcache
  rm -rf ${NODEMGR_HOME}/*.log* ${NODEMGR_HOME}/NodeManagerLogs ${NODEMGR_HOME}/MS*
  echo "Completed"
  exit 0
}

#
# Only delete ESR log files
#
runOnLine()
{
  # Step 1: Delete ESR log files under managed server directory
  echo "Deleting ESR log files under managed server directory"
  rm -rf ${NODEMGR_HOME}/*.log*
  echo "Completed"
  exit 0
}

#
# Check input arguments to run the appropriate options
# A default option is to run in off-line mode.
#
if [ ${#} = 0 ]; then
  showUsage
elif [ ${#} = 1 ]; then
  OPTIONS=${1}
  if [ "x${OPTIONS}" = "x" ]; then
    showUsage
  else
    case $OPTIONS in
    1)
      runOnLine
    ;;
    2)
      runOffLine
    ;;
    *)
      showUsage
    ;;
    esac
  fi
else
  showUsage
fi
