#!/bin/sh
# ******************************************************************************
# This script is used to archive log files in ESRDomain.  Set the parameters
# first before starting this scripts to remove log files.
#
# DOMAIN_HOME       - The directory in which the ESR domain files are stored
# NODEMGR_HOME      - The directory in which ESR managed servers are started.
# DOMAIN_NAME       - The ESR domain name
# ADMIN_SERVER_NAME - The ESR admin server name
#
# ******************************************************************************

# Set common environment variables such as WEBLOGIC_CLASSPATH
if [ "$DOMAIN_HOME" == "" ] ; then
   # If the Domain_Home is not found, assume that the setEnv.sh is in the current directory
    if [ -x ./setEnv.sh ] ; then
        . ./setEnv.sh
    else
      echo ./setEnv.sh is not executable or not found.
#      exit 1
    fi
else
    if [ -x ${DOMAIN_HOME}/setEnv.sh ] ; then
        . ${DOMAIN_HOME}/setEnv.sh
    else
      echo ${DOMAIN_HOME}/setEnv.sh is not executable or not found.
#      exit 1
    fi
fi

DT=$(date '+%Y%m%d%H%M')
GZFILE=${TMP}/${DOMAIN_NAME}.${DT}.tar.gz

tar -czPf ${GZFILE} ${DOMAIN_HOME}/*.log* ${DOMAIN_HOME}/${ADMIN_SERVER_NAME}/*.log* ${DOMAIN_HOME}/NodeManagerClientLogs/ESRDomain_MS*/*.log* ${NODEMGR_HOME}/*.log* ${NODEMGR_HOME}/MS*/*.log* ${NODEMGR_HOME}/NodeManagerLogs/ESRDomain_MS*/*.log*
#exit 0
