SET ECHO OFF
SET AUTOCOMMIT OFF
SET FEEDBACK OFF
SET VERIFY OFF
SET TERMOUT OFF
SET TRIMSPOOL OFF
SET SHOW OFF


-- ESR CR 8346 script.
-- Database script to populate the Permanent Indicator as 'Unknown' for Catastrophic Disability records where it is null.


SET TERMOUT ON
BEGIN
   DBMS_OUTPUT.put_line (' ');
   DBMS_OUTPUT.put_line ('ESR CR 8346 populate the Permanent Indicator for Catastrophic Disability records.');
   DBMS_OUTPUT.put_line (' ');
END;
/
SET TERMOUT OFF

-- populate Permanent Indicator script

UPDATE CAT_DSBLTY_CONDITION 
SET PRMNT_DSBLTY_STDYESNO_ID = (SELECT ID FROM SDSADM.STD_YESNOCODE WHERE ALPHACODE = 'U'), 
RECORD_MODIFIED_BY = 'CCR8346-SET PERM INDICATOR', RECORD_MODIFIED_COUNT = RECORD_MODIFIED_COUNT + 1, 
RECORD_MODIFIED_DATE = current_date  
WHERE PRMNT_DSBLTY_STDYESNO_ID is NULL;


SET TERMOUT ON
BEGIN
   DBMS_OUTPUT.PUT_LINE('Updated permanent indicator as Unknown');
END;
/
SET TERMOUT OFF

SET TERMOUT ON
BEGIN
   DBMS_OUTPUT.PUT_LINE('Calling uow.sql &1');
END;
/
SET TERMOUT OFF
@@uow.sql &1

SET TERMOUT ON
BEGIN
   DBMS_OUTPUT.PUT_LINE('Done.');
END;
/
SET TERMOUT OFF
-- Reset environment parameters
SET FEEDBACK ON
SET VERIFY ON
SET TERMOUT ON
