SET ECHO OFF
SET AUTOCOMMIT OFF
SET FEEDBACK OFF
SET VERIFY OFF
SET TERMOUT OFF
SET TRIMSPOOL OFF
SET SHOW OFF

-- ESR CR 7650: There are 1141 records currently in production 
-- where there is an ineligible date and the person is not service 
-- connected, but the veteran indicator is yes.  This results in 
-- the Primary Eligibility Code incorrectly calculating to NSC.  
-- These records need to be resolved by setting the veteran 
-- indicator = 0.


SET TERMOUT ON
BEGIN
   DBMS_OUTPUT.put_line (' ');
   DBMS_OUTPUT.put_line ('ESR CR 7650: DataSync -- change Veteran Indicator to 0.');
   DBMS_OUTPUT.put_line (' ');
END;
/

SET TERMOUT OFF

UPDATE person 
	SET veteran_ind = '0', 
		RECORD_MODIFIED_BY = 'ESR_CCR7650',
        RECORD_MODIFIED_DATE = SYSDATE,
        RECORD_MODIFIED_COUNT = RECORD_MODIFIED_COUNT + 1
WHERE person_id in
(SELECT p.person_id
  FROM person p, service_connected sc, ineligible_ruling ir
 WHERE p.veteran_ind = '1'
   AND sc.person_id = p.person_id
   AND sc.service_connected_ind = '0'
   AND ir.person_id = p.person_id
   AND ir.ineligible_date IS NOT NULL);

SET TERMOUT ON
BEGIN
   DBMS_OUTPUT.PUT_LINE('Changed Veteran Indicator to 0.');
END;
/
SET TERMOUT OFF

SET TERMOUT ON
BEGIN
   DBMS_OUTPUT.PUT_LINE('Calling uow.sql &1');
END;
/
SET TERMOUT OFF
@@uow.sql &1

SET TERMOUT ON
BEGIN
   DBMS_OUTPUT.PUT_LINE('Done.');
END;
/
SET TERMOUT OFF
-- Reset environment parameters
SET FEEDBACK ON
SET VERIFY ON
SET TERMOUT ON
