SET ECHO OFF
SET AUTOCOMMIT OFF
SET FEEDBACK OFF
SET VERIFY OFF
SET TERMOUT OFF
SET TRIMSPOOL OFF
SET SHOW OFF


-- ESR CR 7228 Agent Orange Indicator Cleanup script.
-- This script should be run after Data Migration and before Bulk E&E. 
-- It fixes records in ADR where Agent Orange Indicator is Yes and 
-- Agent Orange Location is NULL by setting Agent Orange Indicator 
-- value to No.

SET TERMOUT ON
BEGIN
   DBMS_OUTPUT.put_line (' ');
   DBMS_OUTPUT.put_line ('ESR CR 7228 Cleanup script to correct Agent Orange Indicator value.');
   DBMS_OUTPUT.put_line (' ');
END;
/

SET TERMOUT OFF

-- 1504001 = NO
-- 1504002 = YES

UPDATE SPECIAL_FACTOR
  SET SPECIAL_FACTOR_STDYESNO_ID = 1504001
  WHERE SPCL_FACTOR_MAPPING_TYPE_CODE = 'AOE' and 
	SPECIAL_FACTOR_STDYESNO_ID = 1504002 and 
	AGENT_ORANGE_LOCATION_TYPE_ID is null;


SET TERMOUT ON
BEGIN
   DBMS_OUTPUT.PUT_LINE('Changed Agent Orange Indicator to No where the current value is Yes and AgentOrangeLocation is NULL.');
END;
/
SET TERMOUT OFF

SET TERMOUT ON
BEGIN
   DBMS_OUTPUT.PUT_LINE('Calling uow.sql &1');
END;
/
SET TERMOUT OFF
@@uow.sql &1

SET TERMOUT ON
BEGIN
   DBMS_OUTPUT.PUT_LINE('Done.');
END;
/
SET TERMOUT OFF
-- Reset environment parameters
SET FEEDBACK ON
SET VERIFY ON
SET TERMOUT ON
