@REM ### This script update your local ESR project with latest edblib files ###
@echo off


echo ############ Set variables ############
set PROJDIR=Z:\z
if not "%EDB_PROJECT_HOME%" == "" (
  set PROJDIR="%EDB_PROJECT_HOME%"
)
echo Set PROJDIR to %PROJDIR% ...
if not exist %PROJDIR%\Libraries (
  echo Please set correct PROJDIR before running this script!
  goto DONE
)
set srcdir=\\DNS   mul94\build$
echo %computername% | find "ISD" > :NUL
if %errorlevel% == 0 (
  set srcdir=\\DNS   appr1\esr-vss$
)
set tgtdir=%PROJDIR%
set dirLibEDB=%tgtdir%\Libraries\edblib
set dirLibCommon=%tgtdir%\Common\lib
set dirLibComms=%tgtdir%\Comms\lib
set dirLibMessaging=%tgtdir%\Messaging\lib
set dirLibUI=%tgtdir%\UI\lib
set dirLibILOG=%tgtdir%\ILOG\lib


echo ############ Back up existing edb jar files ############
for /f "tokens=2-4 delims=.:-/ " %%a in ('date /t') do (
  set mm=%%a& set dd=%%b& set yyyy=%%c
)
for /f "tokens=1-3 delims=.:-/ " %%a in ('time /t') do (
  set hh=%%a& set mn=%%b& set ap=%%c
)
set dirBackup=%tgtdir%\Libraries\edblib%yyyy%%mm%%dd%%hh%%mn%%ap%
echo Backing up existing edblib files to 
echo     %dirBackup% ...
mkdir %dirBackup%
pushd %dirLibEDB%
copy /y *.jar %dirBackup%
popd


echo ############ Copy over latest edb jar files ############
echo Updating %dirLibEDB% ...
  del /q /f %dirLibEDB%\*.jar
  copy /y %srcdir%\*.jar %dirLibEDB%

if exist %dirLibCommon% (
  echo Updating %dirLibCommon% ...
  del /q /f %dirLibCommon%\*.jar
  copy /y %dirLibEDB%\framework.jar %dirLibCommon%
  rem copy /y %dirLibEDB%\comms.jar %dirLibCommon%
  rem copy /y %dirLibEDB%\workflow.jar %dirLibCommon%
)
if exist %dirLibComms% (
  echo Updating %dirLibComms% ...
  del /q /f %dirLibComms%\*.jar
  copy /y %dirLibEDB%\framework.jar %dirLibComms%
  copy /y %dirLibEDB%\common.jar %dirLibComms%
  rem copy /y %dirLibEDB%\workflow.jar %dirLibComms%
)
if exist %dirLibMessaging% (
  echo Updating %dirLibMessaging% ...
  del /q /f %dirLibMessaging%\*.jar
  copy /y %dirLibEDB%\framework.jar %dirLibMessaging%
  copy /y %dirLibEDB%\common.jar %dirLibMessaging%
  rem copy /y %dirLibEDB%\comms.jar %dirLibMessaging%
  rem copy /y %dirLibEDB%\workflow.jar %dirLibMessaging%
)
if exist %dirLibUI% (
  echo Updating %dirLibUI% ...
  del /q /f %dirLibUI%\*.jar
  copy /y %dirLibEDB%\framework.jar %dirLibUI%
  copy /y %dirLibEDB%\common.jar %dirLibUI%
  rem copy /y %dirLibEDB%\comms.jar %dirLibUI%
  rem copy /y %dirLibEDB%\workflow.jar %dirLibUI%
)
if exist %dirLibILOG% (
  echo Updating %dirLibILOG% ...
  del /q /f %dirLibILOG%\*.jar
  copy /y %dirLibEDB%\framework.jar %dirLibILOG%
  copy /y %dirLibEDB%\common.jar %dirLibILOG%
)


echo ############ Show file timestamps ############
dir %dirLibEDB%\*.jar | find "jar"
echo.&echo.


:DONE
ping 9.9.9.9 > :NUL