<%@ page language="java" %>
<%@ page import="gov.vha.edb.rules.repository.EDBRepository" %>
<%@ page import="gov.vha.edb.rules.web.SessionListener" %>
<%@ page import="gov.vha.edb.rules.web.builder.WebBuilder" %>
<%@ page import="ilog.rules.repository.model.*" %>
<%@ page import="ilog.rules.repository.facility.*" %>
<%@ page import="ilog.rules.repository.brm.*" %>
<%@ page import="ilog.rules.repository.brm.IlrBrmDeployer" %>
<%@ page import="ilog.rules.repository.relational.*" %>
<%@ page import="ilog.rules.repository.relational.util.*" %>
<%@ page import="ilog.rules.repository.relational.sql.*" %>
<%@ page import="java.util.Iterator" %>
<%@ page import="javax.servlet.http.HttpSessionBindingListener" %>
<%@ page import="javax.servlet.http.HttpSessionBindingEvent" %>

<%
  //String login = request.getParameter("login");
  //String password = request.getParameter("password");
  //String url = request.getParameter("url");
  //String driver = request.getParameter("driver");
  //String vendor = request.getParameter("vendor");
  //String mode = request.getParameter("mode");
  //IlrRepository rep = new IlrBrmRepository();
  
  String vendor = session.getServletContext().getInitParameter("database.vendor");
  String driver = session.getServletContext().getInitParameter("database.driver");
  String url = session.getServletContext().getInitParameter("database.url");
  String login = session.getServletContext().getInitParameter("database.userid");
  String password = session.getServletContext().getInitParameter("database.password");
  String mode = session.getServletContext().getInitParameter("database.mode");

  EDBRepository rep = new EDBRepository();
  rep.setClassLoader(this.getClass().getClassLoader());
  IlrPersistenceHandler handler;
  if ("Compact".equals(mode)) {
    IlrCompactedDbPersistenceHandler dbhandler
      = new IlrCompactedDbPersistenceHandler(rep, url, login, password, driver, vendor);
    dbhandler.open();
    handler = dbhandler;
  }
  else {
	IlrDbPersistenceHandler dbhandler
      = new IlrDbPersistenceHandler(rep, url, login, password, driver, vendor);
    dbhandler.open();
    handler = dbhandler;
  }
  SessionListener.register(session, rep);
  rep.setPersistenceHandler(handler);
  IlrPersistenceManager pmgr = rep.getPersistenceManager();
  //pmgr.getLockManager().setLockingEnabled(false);
  pmgr.addPersistenceHandler(handler);
  try {
    pmgr.loadRepository(false);
  } catch (IlrRepException e) {
    throw new ServletException(e);
  }
  WebBuilder builder = WebBuilder.getInstance(request);
  builder.setCurrentRepository(rep);
  String projectName = request.getParameter("project");
  IlrProject project = null;
  if (projectName!=null) {
    project = (IlrProject)rep.findElement(projectName);
  }
  if (project==null) {
    Iterator it = rep.content();
    while (it.hasNext()) {
      Object obj = it.next();
      if (obj instanceof IlrProject) {
        project = (IlrProject)obj;
        break;
      }
    }
  }
  if (project==null) {
    // Creates a project.
    project = IlrProject.createProject(rep.getDefaultExtent());
  }
  
  // this insures that the reflect used internally (conversion, checks, ...) 
  // will know classes in the war (IlrContext required)
  // Beware that the XOM classes have also to be added in the war or server classpath
  IlrBrmDeployer deployer = (IlrBrmDeployer) project.getDeployer();
  deployer.getXOM().getReflect().setClassLoader(this.getClass().getClassLoader());
  
  builder.setCurrentProject(project);
  response.sendRedirect(request.getContextPath()+"/jsp/main.jsp");
%>
