/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.web.builder;

import ilog.rules.dt.util.*;
import ilog.rules.util.prefs.*;

import java.util.*;

/**
 * <p>Specialized version of <code>IlrDTUtil</code> for the Web Builder.</p>
 */
public class WebDtUtil extends IlrDTUtil
{
  private Properties preferenceProperties;
  private ResourceBundle messagesBundle;

  public WebDtUtil(ResourceBundle messagesBundle, Properties preferenceProperties)
  {
    this.messagesBundle = messagesBundle;
    this.preferenceProperties = preferenceProperties;
  }

  protected String getMessageInternal(String key, String defaultValue)
  {
    String res;
    try {
      res = messagesBundle.getString(key);
    } catch (java.util.MissingResourceException e) {
      res = null;
    }
    return (res != null) ? res : defaultValue;
  }

  protected String getPropertyInternal(String key, String defaultValue)
  {
    return preferenceProperties.getProperty(key, defaultValue);
  }

  public String getLabelInternal(IlrPropertyBundle bundle, String key)
  {
    return getMessageInternal(key + ".text", key);
  }

  //          public IlrPropertyBundle getDTPreferencesBundle()
  //          {
  //            return preferencesBundle;
  //          }
  //
  //          public IlrPropertyBundle getDTMessagesBundle()
  //          {
  //            return messagesBundle;
  //          }

}
