/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.web.builder;

import ilog.rules.repository.event.FeatureChangeEvent;
import ilog.rules.repository.model.IlrConstants;
import ilog.rules.repository.model.IlrElement;
import ilog.rules.repository.model.IlrModelElement;
import ilog.rules.webui.IlrWPropertySheet;
import ilog.webui.dhtml.IlxWPort;

import java.io.IOException;
import java.util.EventObject;

public class PropertyPanel extends ElementPanel {

  private static final long serialVersionUID = 2296618696655039620L;
  private IlrWPropertySheet sheet;

    public PropertyPanel(WebBuilder builder) {
      super(builder);
      sheet = new IlrWPropertySheet();
      configureLayout();
    }

  public void configureLayout() {
    sheet.safeRemove();
    if (getBuilder().getPropertiesPlacement() == WebBuilder.PROPERTIES_CENTER) {
      sheet.setTabbedPane(getBuilder().getCenterPanel().getPane());
    } else {
      sheet.setTabbedPane(null);
      add(sheet);
    }
  }

  public IlrWPropertySheet getPropertySheet() {
    return sheet;
  }

  protected IlrModelElement getModelElement() {
    return (IlrModelElement)getElement();
  }

  protected void printComponent(IlxWPort port) throws IOException {
    Util.startDiv(port, "width:100%;height:100%");
    sheet.print(port);
    Util.endDiv(port);
  }

  public void setElement(IlrElement element) {
    super.setElement(element);
    sheet.setElement(element);
  }

  public void featureChanged(FeatureChangeEvent evt) {
    String propName = evt.getPropertyName();
    Object source = evt.getSource();
    if (source == this.element) {
      if (propName == IlrConstants.MODIFIED_PROPERTY) {
        getBuilder().updateActionStates();
      }
    }
  }

  public void structureChanged(EventObject e) {
  }

}
