/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.web.builder;

//import ilog.rules.repository.facility.IlrPersistenceHandler;
import ilog.rules.repository.facility.IlrPersistenceManager;
import ilog.rules.repository.model.*;
import ilog.rules.util.logging.Level;
import ilog.webui.dhtml.IlxWPort;

//framework
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LockManagement
{
	// Lock/Unlock action
	public static final String ACTION_LOCK = "lock";
	public static final String ACTION_UNLOCK = "unlock";
	public static final String ACTION_UPDATE_LOCK = "updateLock";
	
	private static Log logger = LogFactory.getLog(LockManagement.class );

	public static class LockAction extends WebAction
	{
		private static final long serialVersionUID = -6973295416433686441L;

        public LockAction(){
			super( ACTION_LOCK );
		}

		public boolean isEnabled(WebBuilder builder){
			IlrElement elt = builder.getExplorerPanel().getSelectedElement();
			if (elt == null){
				return false;
			}
			IlrPersistenceManager manager = elt.getRepository().getPersistenceManager();
			if (!manager.isLockingEnabled()){
				return false;
			}
			if(!manager.isLockable(elt) || elt.hasPathWriteLock() || elt.isPathBusy()){
                return false;
			}
			return true;	
		}

		public void invoke(IlxWPort port, String[] args){
			WebBuilder builder = WebBuilder.getInstance(port.getRequest());
			IlrElement elt = builder.getExplorerPanel().getSelectedElement();
			if (elt != null){
				 try  {
					elt.getRepository().getPersistenceManager().setWriteLock(elt);
				 }
				 catch( IlrRepException ex )  {
				 	Throwable t = getFirstCause(ex);
			        builder.addAlert(t.getMessage());
			        builder.getLogger().log(Level.FINEST, "Error during action " +
			                                getName(), ex);
				 }
			}
		}

	}


	public static class UnlockAction extends WebAction
	{
		private static final long serialVersionUID = 6365936845141367463L;

        public UnlockAction(){
			super( ACTION_UNLOCK );
		}

		public boolean isEnabled( WebBuilder builder )	{
			IlrElement elt = builder.getExplorerPanel().getSelectedElement();
			if ( elt == null || !elt.getRepository().getPersistenceManager().isLockingEnabled()){
				return false;
			}
			if(!elt.hasWriteLock()){
                return false;
			}
			return true;
		}

		public void invoke( IlxWPort port, String[] args )	{
			WebBuilder builder = WebBuilder.getInstance( port.getRequest() );
			IlrElement elt = builder.getExplorerPanel().getSelectedElement();
			if ( elt != null )	{
				 try {
				 	elt.getRepository().getPersistenceManager().removeWriteLock(elt);
				 }
				 catch( IlrRepException ex ) {
			        Throwable t = getFirstCause(ex);
			        builder.addAlert(t.getMessage());
			        builder.getLogger().log(Level.FINEST, "Error during action " +
			                                getName(), ex);
				 }
			}
		}
	}
	
	/*
	public static class UnLockAction extends WebAction
	{
		public UnLockAction(){
			super( ACTION_UNLOCK );
		}

		public boolean isEnabled( WebBuilder builder )	{
			IlrElement elt = builder.getExplorerPanel().getSelectedElement();
			if ( elt == null || !elt.getRepository().getPersistenceManager().isLockingEnabled()){
				return false;
			}
			if(!elt.hasWriteLock()){
                return false;
			}
			return true;
		}

		public void invoke( IlxWPort port, String[] args )	{
			WebBuilder builder = WebBuilder.getInstance( port.getRequest() );
			IlrElement elt = builder.getExplorerPanel().getSelectedElement();
			if ( elt != null )	{
				 try {
				 	elt.getRepository().getPersistenceManager().removeWriteLock(elt);
				 }
				 catch( IlrRepException ex ) {
			        Throwable t = getFirstCause(ex);
			        builder.addAlert(t.getMessage());
			        builder.getLogger().log(Level.FINEST, "Error during action " +
			                                getName(), ex);
				 }
			}
		}
	} */
}