/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.web.builder;

//import ilog.rules.repository.brm.IlrBrmConstants;
import ilog.rules.repository.event.ElementListener;
import ilog.rules.repository.event.ElementRemoveEvent;
import ilog.rules.repository.event.FeatureChangeEvent;
//import ilog.rules.repository.model.IlrBaseElement;
import ilog.rules.repository.model.IlrElement;
//import ilog.rules.repository.model.IlrElementClass;
//import ilog.rules.repository.model.IlrRefPackage;
import ilog.rules.ui.editor.explorer.tree.IlrExplorerTreeNode;
import ilog.rules.webui.IlrWRepExplorer;
import ilog.webui.dhtml.components.IlxWLabel;

import javax.swing.tree.TreePath;
import java.util.EventObject;


/**
 * <p>Browser panel.</p>
 */
public class ExplorerPanel extends IlrWRepExplorer
  implements ElementListener {


  private static final long serialVersionUID = 6505637889860694787L;
  private WebBuilder builder;

    private class BrowserSelectionModel
      extends javax.swing.tree.DefaultTreeSelectionModel {
      private static final long serialVersionUID = -1381419259259455511L;

    public void setSelectionPaths(javax.swing.tree.TreePath[] pPaths) {
        super.setSelectionPaths(pPaths);
        TreePath path = pPaths[0];
        IlrExplorerTreeNode node =
          (IlrExplorerTreeNode) path.getLastPathComponent();
        Object item = node.getItem();
        if (item instanceof IlrElement) {
          IlrElement elt = (IlrElement)item;
          setElement(elt);
          builder.setEditedElement(elt);
        }
      }
    }

  private IlrElement element;

  public void setElement(IlrElement element) {
    IlrElement oldElement = this.element;
    this.element = element;
    if (oldElement!=null) {
      oldElement.removeElementListener(this);
    }
    if (element!=null) {
      element.addElementListener(this);
    }
  }

  public ExplorerPanel(WebBuilder builder) {
    this.builder = builder;
    getTree().setSelectionModel(new BrowserSelectionModel());
  }

  protected void configureRenderer(IlrElement element, IlxWLabel label) {
    if (builder.isElementCut(element)) {
      String cutFilter = "Alpha(opacity=25)";
      label.getIcon().getStyle().set("filter", cutFilter);
    }
  }

  public void featureChanged(FeatureChangeEvent e) {
  }

  public void structureChanged(EventObject e) {
  }

  public void elementRemoved(ElementRemoveEvent e) {
    getTree().clearSelection();
    builder.setEditedElement(null);
  }

}
