/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.web.builder;

import ilog.rules.repository.event.ElementListener;
import ilog.rules.repository.event.ElementRemoveEvent;
import ilog.rules.repository.event.FeatureChangeEvent;
import ilog.rules.repository.model.IlrElement;
import ilog.webui.dhtml.IlxWComponent;

public abstract class ElementPanel extends IlxWComponent
  implements ElementListener {

  protected WebBuilder builder;
  protected IlrElement element;

  protected WebBuilder getBuilder() {
    return builder;
  }

  protected IlrElement getElement() {
    return element;
  }

  public ElementPanel(WebBuilder builder) {
    this.builder = builder;
  }

  public void setElement(IlrElement element) {
    IlrElement oldElement = this.element;
    this.element = element;
    if (oldElement!=null) {
      oldElement.removeElementListener(this);
    }
    if (element!=null) {
      element.addElementListener(this);
    }
  }

  public void featureChanged(FeatureChangeEvent event) {
  }

  public void elementRemoved(ElementRemoveEvent event) {
  }

  public void undo() {
  }

  public void redo() {
  }

  public boolean canUndo() {
    return false;
  }

  public boolean canRedo() {
    return false;
  }

}
