/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.web.builder;

import ilog.rules.repository.facility.IlrPersistenceManager;
import ilog.rules.repository.model.IlrElement;
import ilog.rules.repository.model.IlrElementClass;
import ilog.rules.repository.model.IlrPackage;
import ilog.rules.repository.model.IlrRefPackage;
import ilog.rules.repository.model.IlrRepException;
import ilog.rules.repository.brm.IlrElementVersion;

import ilog.rules.repository.brm.IlrBrmConstants;
import ilog.webui.dhtml.IlxWPort;

//framework
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ControlActions
{
	// Lock/Unlock/Update action
	public static final String ACTION_LOCK = "lock";
	public static final String ACTION_UNLOCK = "unlock";
	public static final String ACTION_UPDATE_LOCK = "updateLock";
	// Create/Restore Version action
	public static final String ACTION_CREATE_VERSION = "createVersion";
	public static final String ACTION_RESTORE_VERSION = "restoreVersion";
	
	private static Log logger = LogFactory.getLog(ControlActions.class );

	public static class LockAction extends WebAction
	{
		private static final long serialVersionUID = 2088716067768908693L;

        public LockAction(){
			super( ACTION_LOCK );
		}

		public boolean isEnabled(WebBuilder builder){
			IlrElement elt = builder.getExplorerPanel().getSelectedElement();
			if (elt == null){
				return false;
			}
			IlrPersistenceManager manager = elt.getRepository().getPersistenceManager();
			if (!manager.isLockingEnabled()){
				return false;
			}
			if(!manager.isLockable(elt) || elt.hasPathWriteLock() || elt.isPathBusy()){
                return false;
			}
			return true;	
		}

		public void invoke(IlxWPort port, String[] args) throws IlrRepException 
		{
			WebBuilder builder = WebBuilder.getInstance(port.getRequest());
			IlrElement elt = builder.getExplorerPanel().getSelectedElement();
			if (elt != null){
				elt.getRepository().getPersistenceManager().setWriteLock(elt);
				builder.getExplorerPanel().repaintItem(elt);
				builder.updateActionStates();
			}
		}

	}


	public static class UnlockAction extends WebAction
	{
		private static final long serialVersionUID = 8101319223316442802L;

        public UnlockAction(){
			super( ACTION_UNLOCK );
		}

		public boolean isEnabled( WebBuilder builder )	{
			IlrElement elt = builder.getExplorerPanel().getSelectedElement();
			if ( elt == null || !elt.getRepository().getPersistenceManager().isLockingEnabled()){
				return false;
			}
			if(!elt.hasWriteLock()){
                return false;
			}
			return true;
		}

		public void invoke( IlxWPort port, String[] args ) throws IlrRepException	
		{
			WebBuilder builder = WebBuilder.getInstance( port.getRequest() );
			IlrElement elt = builder.getExplorerPanel().getSelectedElement();
			if ( elt != null )	{
				elt.getRepository().getPersistenceManager().removeWriteLock(elt);
				builder.getExplorerPanel().repaintItem(elt);
				builder.updateActionStates();
			}
		}
	}
	
	
	public static class UpdateLockAction extends WebAction
	{
		private static final long serialVersionUID = -8721597795891507312L;

        public UpdateLockAction(){
			super( ACTION_UPDATE_LOCK );
		}

		public boolean isEnabled( WebBuilder builder )	{
			return (builder.getCurrentRepository().getPersistenceManager().isLockingEnabled());
		}

		public void invoke( IlxWPort port, String[] args ) throws IlrRepException	
		{
			WebBuilder builder = WebBuilder.getInstance(port.getRequest());
			builder.getCurrentRepository().getPersistenceManager().readLocks();
			builder.getExplorerPanel().invalidate();
		}
	} 
	
	public static class CreateVersionAction extends WebAction
	{
		private static final long serialVersionUID = 2801696207704448990L;

        public CreateVersionAction(){
			super( ACTION_CREATE_VERSION );
		}

		public boolean isEnabled(WebBuilder builder)	{
			IlrElement elt = builder.getEditedElement();
            if ( elt == null ){
                return false;
            }
            
            IlrRefPackage refPack = builder.getCurrentExtent();
            IlrElementClass ruleClass = refPack.getElementClass(IlrBrmConstants.BRM_RULE_CLASS);
            if (!(elt.isInstanceOf(ruleClass, true) && ((IlrElementVersion)elt).isWorkingVersion())){
            	return false;
            }
            
            IlrElementClass pkgClass = refPack.getElementClass(IlrBrmConstants.RULE_PACKAGE_CLASS);
            IlrPackage p = builder.getCurrentPackage();
            return (p != null && !p.isFrozen() && (p.isInstanceOf(pkgClass, true)));
		}

		public void invoke( IlxWPort port, String[] args ) throws IlrRepException	
		{
			WebBuilder builder = WebBuilder.getInstance(port.getRequest());
            IlrElement elt = builder.getEditedElement();
            if (elt == null){
            	return;
            }
            IlrElementClass ruleClass = builder.getCurrentExtent().getElementClass(IlrBrmConstants.BRM_RULE_CLASS);
            if (elt.isInstanceOf(ruleClass, true) && ((IlrElementVersion)elt).isWorkingVersion()){
            	((IlrElementVersion)elt).createHistoryVersion();
            }
		}
	} 
	
	public static class RestoreVersionAction extends WebAction
	{
		private static final long serialVersionUID = 5496703655244211484L;

        public RestoreVersionAction(){
			super(ACTION_RESTORE_VERSION);
		}

		public boolean isEnabled(WebBuilder builder){
			IlrElement elt = builder.getEditedElement();
            if ( elt == null ){
                return false;
            }
            
            IlrRefPackage refPack = builder.getCurrentExtent();
            IlrElementClass ruleClass = refPack.getElementClass(IlrBrmConstants.BRM_RULE_CLASS);
            if (!(elt.isInstanceOf(ruleClass, true) && ((IlrElementVersion)elt).isHistoryVersion())){
            	return false;
            }
            
            IlrElementClass pkgClass = refPack.getElementClass(IlrBrmConstants.RULE_PACKAGE_CLASS);
            IlrPackage p = builder.getCurrentPackage();
            return (p != null && !p.isFrozen() && (p.isInstanceOf(pkgClass, true)));
		}

		public void invoke(IlxWPort port, String[] args) throws IlrRepException	
		{
			WebBuilder builder = WebBuilder.getInstance(port.getRequest());
            IlrElement elt = builder.getEditedElement();
            if (elt == null){
            	return;
            }
            IlrElementClass ruleClass = builder.getCurrentExtent().getElementClass(IlrBrmConstants.BRM_RULE_CLASS);
            if (elt.isInstanceOf(ruleClass, true) && ((IlrElementVersion)elt).isHistoryVersion()){
                ((IlrElementVersion)elt).restoreVersion();
            }
		}
	} 
}