/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.web.builder;

import ilog.webui.dhtml.IlxWManager;
import ilog.webui.dhtml.IlxWComponent;
import ilog.webui.dhtml.IlxWPort;
import ilog.webui.dhtml.IlxWUtil;

import java.io.IOException;
import java.io.PrintWriter;

public class ClientProperties extends IlxWComponent {

  private static final long serialVersionUID = -1382209778038419828L;
  private boolean modified;

    private void printProperty(PrintWriter out, String name, String value)
      throws IOException {
      if (value!=null) {
        out.println("<input type=\"hidden\" name=\""
                    +name+"\" value=\""
                    +IlxWUtil.toXml(value)+"\"></input>");
      }
    }

  protected void printComponent(IlxWPort port) throws IOException {
    IlxWManager manager = getManager();
    PrintWriter out = port.getWriter();
    out.println("<form name=\"clientProperties\">");
    printProperty(out, "modified", (new Boolean(modified)).toString());
    out.println("</form>");
  }

  public boolean isModified() {
	  return modified;
  }

  public void setModified(boolean modified) {
	  this.modified = modified;
  }
}
// end of ClientProperties.java



