/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.web.builder;

import ilog.rules.repository.brm.IlrBOM;
import ilog.rules.repository.brm.IlrBrmConstants;
import ilog.rules.repository.brm.IlrBrmElement;
import ilog.rules.repository.event.FeatureChangeEvent;
import ilog.rules.repository.model.IlrElement;
import ilog.rules.repository.model.IlrElementClass;
import ilog.webui.dhtml.IlxWComponent;
import ilog.webui.dhtml.IlxWPort;
//import ilog.webui.dhtml.IlxWBrowserInfo;
import ilog.webui.dhtml.components.IlxWTabbedPane;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;

public class CenterPanel extends ElementPanel {

  private static final long serialVersionUID = 6516457552676133126L;
  private IlxWTabbedPane pane;
  private ArrayList tabs;
  private BrmElementPanel brmElementPanel;

    public CenterPanel(WebBuilder builder) {
      super(builder);
      pane = new IlxWTabbedPane() {
        private static final long serialVersionUID = 0L;

        protected String getHtmlTagName(IlxWPort port) {
          return "div";
        }
      };
      pane.getStyle().set(PROP_WIDTH, "100%");
      pane.getStyle().set(PROP_HEIGHT, "100%");
      tabs = new ArrayList();
      configureLayout();
    }

  public IlxWTabbedPane getPane() {
    return pane;
  }

  public void configureLayout() {
    safeAdd(pane);
    removeElementTabs();
    setElement(getElement());
  }

  private void removeElementTabs() {
    int size = tabs.size();
    for (int i=0; i<size; i++) {
      IlxWComponent c = (IlxWComponent)tabs.get(i);
      pane.remove(c);
    }
    tabs.clear();
  }

  public void setElement(IlrElement element) {
    if (element!=null) {
      String name = element.getElementClass().getQualifiedName()+"";
      if (element instanceof IlrBrmElement) {
        setBrmElement((IlrBrmElement)element);
      } else if (IlrBrmConstants.BOM_CLASS.equals(name)) {
        setBOM((IlrBOM)element);
      } else {
        removeElementTabs();
        invalidate();
      }
    } else {
      removeElementTabs();
      // Force the panel to be reprinted so that the image is displayed.
      this.invalidate();
    }
    super.setElement(element);
  }

  private void setBrmElement(IlrBrmElement element) {
    invalidate();
    if (brmElementPanel==null) {
      brmElementPanel = new BrmElementPanel(getBuilder());
    }
    int i = pane.indexOfComponent(brmElementPanel);
    String title = (element==null)?"-?-":element.getDisplayName();
    if (i == -1) {
      addTab(title, brmElementPanel);
    } else {
      pane.setTitleAt(i, title);
    }
    brmElementPanel.setElement(element);
  }

  public void featureChanged(FeatureChangeEvent evt) {
    super.featureChanged(evt);
    String propName = evt.getPropertyName();
    if (IlrBrmConstants.NAME_PROPERTY.equals(propName)) {
      int i = pane.indexOfComponent(brmElementPanel);
      if (i >= 0) {
        IlrBrmElement elt = (IlrBrmElement)evt.getElement();
        String title = (elt == null) ? "-?-" : elt.getDisplayName();
        pane.setTitleAt(i, title);
      }
    }
  }

  public void structureChanged(EventObject e) {
  }

  private void setBOM(IlrBOM bom) {
    invalidate();
    int i = pane.indexOfTab("BOM");
    ElementPanel panel;
    if (i==-1) {
      panel = new BOMPanel(getBuilder());
      addTab("BOM", panel);
    } else {
      panel = (ElementPanel)pane.getComponentAt(i);
    }
    panel.setElement(bom);
  }

  private void addTab(String title, IlxWComponent component) {
    for (int i=0; i<tabs.size(); i++) {
      pane.remove((IlxWComponent)tabs.get(i));
    }
    tabs.clear();
    pane.insertTab(title, null, component, title, 0);
    tabs.add(component);
  }


  protected void printComponent(IlxWPort port) throws IOException {
    if (pane.getTabCount()>0) {
      //Util.startDiv(port, "width:100%;height:100%");
      pane.print(port);
      //Util.endDiv(port);
    } else {
      String contextPath = port.getRequest().getContextPath();
      port.getWriter().println("<img src=\""+contextPath
                               +"/images/webruleeditor.gif\"></img>");
    }
  }

  public void undo() {
    if (brmElementPanel!=null) {
      brmElementPanel.undo();
    }
  }

  public void redo() {
    if (brmElementPanel!=null) {
      brmElementPanel.redo();
    }
  }

  public void check() {
    if (brmElementPanel!=null) {
      brmElementPanel.check();
    }
  }

  public boolean canUndo() {
    if (brmElementPanel!=null) {
      return brmElementPanel.canUndo();
    }
    return false;
  }

  public boolean canRedo() {
    if (brmElementPanel!=null) {
      return brmElementPanel.canRedo();
    }
    return false;
  }

  public boolean canCheck() {
    if (brmElementPanel!=null) {
      WebBuilder builder = getBuilder();
      IlrElement elt = builder.getEditedElement();
      if (elt==null) {
        return false;
      }
      IlrElementClass ruleClass
        = builder.getCurrentExtent().getElementClass(IlrBrmConstants.BRM_RULE_CLASS);
      if (elt.isInstanceOf(ruleClass, true)) {
        return brmElementPanel.canCheck();
      }
    }
    return false;
  }

}
