/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.web.builder;

import ilog.rules.repository.brm.IlrBOM;
import ilog.webui.dhtml.IlxWBrowserInfo;
import ilog.webui.dhtml.IlxWPort;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.EventObject;

public class BOMPanel extends ElementPanel {
    private static final long serialVersionUID = -1006094426211400719L;


    public BOMPanel(WebBuilder builder) {
      super(builder);
    }

  protected IlrBOM getBOM() {
    return (IlrBOM)getElement();
  }

  protected void printComponent(IlxWPort port) throws IOException {
    PrintWriter out = port.getWriter();
    out.println("<table cellpadding=\"5\" height=\"100%\" width=\"100%\" style=\"table-layout:fixed\">");
    out.println("<tr height=\"1%\" valign=\"top\">");
    out.println("<td bgcolor=\"#F5F5F5\" style=\"border-width:3;border-style:inset\">");

    /* Due to several Netscape bugs (for 4.7, 6.2, and 7.0) we cannot use overflow:auto,
       in addition to % dimensions otherwise nothing appears.
       Even with this solution the BOM is not displayed properly under Netscape 4.7 & 3
       but it's better than nothing.
    */
    if (port.getBrowserInfo().getVendor() != IlxWBrowserInfo.VENDOR_NN) {
      out.println("<div nowrap style=\"overflow:auto;height:100%;width:100%\"><code>");
    } else {
      out.println("<div nowrap style=\"overflow:auto;height:600px\"><code>");
    }

    StringWriter sw = new StringWriter();
    getBOM().writeObjectModel(sw);
    StringReader reader = new StringReader(sw.toString());
    PrettyPrinter.prettyPrint(reader, out, "java");
    out.println("</code></div>");
    out.println("</td>");
    out.println("</tr>");
    out.println("</table>");
  }

  public void structureChanged(EventObject e) {
  }
}
