/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.web;

import ilog.webui.dhtml.IlxWResourceManager;

/**
 * <p>Defines the resource manager servlet.
 * The resource manager is the servlet responsible for loading Java resources
 * used by the Web Components framework.</p>
 *
 * <p>For example, if a component wants to print an IMG HTML node
 * referencing a jpg file accessible on the server as a Java resource, it
 * will generate the following HTML code:</p>
 * <ul>&lt;img src="/myapp/servlet/web.ResourceManager/image/jpg/mypackage/foo.jpg"/&gt;</ul>
 *
 * <p>The resource manager servlet must be declared in the web.xml file,
 * and its corresponding path on the web server must be registered as
 * the "ilog.webui.dhtml.resource_path" context parameter of the web
 * application.</p>
 *
 * <p>IMPORTANT NOTE: defining a resource manager servlet is <em>not mandatory</em>.
 * If no resource manager is defined, the Web Components framework
 * will automatically generate a URL made of the path of the
 * controller servlet of the application and a set of request parameters
 * describing the resource information. When requested, this URL will load
 * the resource file through the default resource manager.</p>
 *
 * <p>This class does nothing but define a servlet class extending the
 * standard resource manager provided by the web components. This is
 * because with some existing web servers, each servlet referenced in the
 * web.xml descriptor <em>must</em> be loaded through the web application class
 * loader.</p>
 */
public class ResourceManager extends IlxWResourceManager {

    private static final long serialVersionUID = 559630891287465869L;
}
