/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.web;

import ilog.webui.dhtml.IlxWController;
import ilog.webui.dhtml.IlxWControllerError;
import ilog.webui.dhtml.IlxWRuntimeException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * <p>The controller servlet for the 'builder' web application.
 * This servlet will handle and dispatch events triggered by the client
 * part of the web components. It will also handle errors through the
 * <code>handleError</code> method.</p>
 *
 * <p>The <code>Controller</code> servlet is declared as the controller
 * for the application in the deployment descriptor
 * (see examples/web/webapps/builder/WEB-INF/web.xml).</p>
 */
public class Controller extends IlxWController {
    private static final long serialVersionUID = -5787551759776567942L;


    /**
     * <p>Handles errors thrown by the service method of this servlet.</p>
     */
    protected void handleError(HttpServletRequest request,
                               HttpServletResponse response,
                               IlxWControllerError error,
                               String requestPath)
      throws IOException, ServletException {
      int type = error.getType();
      // A simple example of error handling.
      switch (type) {
      case IlxWControllerError.ERROR_SESSIONTIMEOUT:
        response.sendError(HttpServletResponse.SC_REQUEST_TIMEOUT,
                           "The requested session has expired");
        break;
      case IlxWControllerError.ERROR_COMPONENTEXCEPTION:
        IlxWRuntimeException rte = (IlxWRuntimeException)error.getRootCause();
        Throwable rteCause = rte.getRootCause();
        if (rteCause!=null) {
          throw new ServletException(rteCause);
        } else {
          throw new ServletException(rte);
        }
      default:
        throw new ServletException(error.getRootCause());
      }
    }
}
