/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.repository;

import ilog.rules.repository.model.IlrRepException;
import ilog.rules.repository.brm.IlrBrmRepository;
import ilog.rules.util.prefs.IlrPreferences;

//framework
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * Implements a customized role-based repository class.
 * @author fdwang
 * @version 1.0
 */
public class EDBRepository extends IlrBrmRepository {

    private static final long serialVersionUID = -3265441672884673210L;
    
    private String currentUser = null;
    private String currentRole = null;
    
    private static Log logger = LogFactory.getLog(EDBRepository.class );

    /** Creates a new instance of EDBRepository */
    public EDBRepository() {
        super();
    }
    
    /**
     *  Initializes the repository by adding customizations.
     */
    public void initialize() throws IlrRepException {
    	log("** EDBRepository.initialize() **");

        /**
         * Add custom rule class with extended properties.
         * 1. Add EDBRule as a sub-class of IlrBrmRule
         * 2. Set the custom permission manager
         * 4. Define and add all its specific properties
         */
        super.initialize();
        
        /**
         * Add any other customizations here, e.g.
         * add new properties to the rule class,
         * or add a customized permission manager.
         */
     }

    /**
     *  @return the current user of the repository (same as the login id).
     */
    public String getCurrentUser() { 
        return currentUser; 
    }
    
    /**
     *  @return the role of the current user. See role 'enum' values.
     */
    public String getCurrentRole() { 
        return currentRole; 
    }

    /**
     *  Sets the role according to the username after validating
     *  the username & password.
     *
     *  @param userName the user name (login id).
     *  @param password the password.
     */
    public boolean selectCurrentRole(String userName, String password) {
    	String passwd = IlrPreferences.getString(userName + ".passwd");
        String role = IlrPreferences.getString(userName + ".role");
        
    	if (!validate(userName, password)){
            log("Bad user name or password: " + userName);
            return false;
    	}
    	
        this.currentUser = userName;
        this.currentRole = IlrPreferences.getString(userName + ".role");
        log("Logged in as " + this.currentUser + " in role " + this.currentRole);
    	return true;
    }
    
    /**
     * A static method to validate the user login.
     * @param userName the user id.
     * @param password the password.
     * @return true if the validation is passed, false otherwise.
     */
    public static boolean validate(String userName, String password){
    	boolean valid = false;
    	
    	if (userName == null || password == null){
    		return false;
    	}
    	String role = IlrPreferences.getString(userName + ".role");
    	String passwd = IlrPreferences.getString(userName + ".passwd");
        if (role == null || passwd == null || !password.equals(passwd)){
        	return false;
        }
        
        return true;
    }
    
    /**
     * A helper method to log debug information.
     * @param info the information to log.
     */
    private static void log(String info){
    	if (logger.isDebugEnabled()) {
    		logger.info(info);
    	}
    }
}
