/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.vha.edb.rules.builder;

// Java classes
import java.awt.event.*;
import java.awt.Color;
import javax.swing.*;

import gov.vha.edb.rules.repository.EDBRepository;


/**
 * Provides a simple login dialog for accessing the customized
 * JRules builder (cf. EDBManager).
 *
 * @author  fdwang
 * @version 1.0
 */
public class EDBLoginDialog extends JDialog {
    private static final long serialVersionUID = 8934197626108985121L;


    public EDBLoginDialog() {
        super(new  JFrame(), "ILOG Rule Builder Login", true);
        setDefaultCloseOperation( WindowConstants.DO_NOTHING_ON_CLOSE );
        initComponents();
        this.setBounds(300, 300, 280, 160);
    }
    
    public EDBLoginDialog( JFrame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.setBounds(300, 300, 280, 160);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {
        jLabel1 = new  JLabel();
        userid = new  JTextField();
        jLabel2 = new  JLabel();
        password = new  JPasswordField();
        okButton = new  JButton();
        cancelButton = new  JButton();

        getContentPane().setLayout(null);

        setBackground(Color.lightGray);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jLabel1.setBackground(new Color(0, 0, 255));
        jLabel1.setText("User ID");
        jLabel1.setToolTipText("Enter user id");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(20, 15, 90, 25);

        userid.setToolTipText("place for user id");
        getContentPane().add(userid);
        userid.setBounds(110, 15, 140, 25);

        jLabel2.setText("Password");
        jLabel2.setToolTipText("enter password");
        getContentPane().add(jLabel2);
        jLabel2.setBounds(20, 50, 90, 25);

        password.setToolTipText("place for password");
        getContentPane().add(password);
        password.setBounds(110, 50, 140, 25);

        okButton.setMnemonic('O');
        okButton.setText("Login");
        okButton.setToolTipText("Send userid & Password to login.");
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                loginButtonActionHandler(evt);
            }
        });

        getContentPane().add(okButton);
        okButton.setBounds(20, 90, 100, 25);

        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.setToolTipText("Cancel login and quit.");
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                cancelButtonActionHandler(evt);
            }
        });

        getContentPane().add(cancelButton);
        cancelButton.setBounds(140, 90, 110, 25);

        pack();
    }

    private void loginButtonActionHandler(ActionEvent evt) {
        String passwd = new String(password.getPassword());
        if (passwd == null){
            passwd = "";
        }

        if (!EDBRepository.validate(userid.getText(), passwd)) {
            showErrorMsg("Invalid login/password");
        } 
        else {
          hide();
        }
    }

    private void cancelButtonActionHandler(ActionEvent evt) {
        hide();
        System.exit(0);
    }
    
    /** Closes the dialog */
    private void closeDialog(WindowEvent evt) {
        setVisible(false);
        dispose();
        System.exit(0);
    }
    
    protected void showErrorMsg(String msg) {
         JOptionPane.showMessageDialog(this, msg, "Error",
             JOptionPane.ERROR_MESSAGE);
    }
    
    // Variables declaration
    private  JButton cancelButton;
    private  JLabel jLabel1;
    private  JLabel jLabel2;
    private  JButton okButton;
    private  JPasswordField password;
    private  JTextField userid;
    // End of variables declaration
    
    public String getUserName(){
    	return userid.getText();
    }
    
    public String getPassword(){
    	return (new String(password.getPassword()));
    }
}
