<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:utl="urn:esr-vha-gov:internal:xslt:utilities" 
    extension-element-prefixes="utl">

  <!--**********************************************************************-->
  <!--****************************** Split *********************************-->
  <xsl:template name="utl:split">
    <xsl:param name="dataString" select="''" />
    <xsl:param name="tokenName" select="'token'" />
    <xsl:param name="delimiter" select="' '" />
    <xsl:param name="maxTokens" select="-1" />

    <xsl:choose>
      <xsl:when test="not($dataString)" />
      <xsl:when test="not($tokenName)" />
      <xsl:when test="not($maxTokens) or ($maxTokens = 0)" />

      <xsl:when test="not($delimiter) or ($delimiter = '') or ($maxTokens = 1) or not(contains($dataString, $delimiter))">
        <xsl:element name="{concat('utl:', $tokenName)}">
          <xsl:value-of select="$dataString" />
        </xsl:element>
      </xsl:when>

      <xsl:otherwise>
        <xsl:element name="{concat('utl:', $tokenName)}">
          <xsl:value-of select="substring-before($dataString, $delimiter)" />
        </xsl:element>

        <xsl:call-template name="utl:split">
          <xsl:with-param name="dataString" select="substring-after($dataString, $delimiter)" />
          <xsl:with-param name="delimiter" select="$delimiter" />
          <xsl:with-param name="maxTokens">
            <xsl:choose>
              <xsl:when test="$maxTokens &lt; 0"><xsl:value-of select="-1" /></xsl:when>
              <xsl:otherwise><xsl:value-of select="$maxTokens - 1" /></xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--**********************************************************************-->
  <!--***************************** Combine ********************************-->
  <xsl:template name="utl:combine">
    <xsl:param name="data" />
    <xsl:param name="delimiters" select="' '" />
    <xsl:param name="defaultDelimiter" select="''" />

    <xsl:choose>
      <xsl:when test="not($data)" />

      <xsl:otherwise>
        <xsl:variable name="childCount" select="count(data/*)" />

        <xsl:choose>
          <xsl:when test="$childCount &gt; 0">
            <xsl:variable name="actualDelimiter">
              <xsl:choose>
                <xsl:when test="not($delimiters) or ($delimiters = '')">
                  <xsl:value-of select="$defaultDelimiter" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="substring($delimiters, 1, 1)" />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>

            <xsl:for-each select="$data/*">
              <xsl:call-template name="utl:combine">
                <xsl:with-param name="data" select="." />
                <xsl:with-param name="delimiter" select="substring($delimiters, 2)" />
              </xsl:call-template>

              <xsl:if test="position() != $childCount">
                <xsl:value-of select="$actualDelimiter" />
              </xsl:if>
            </xsl:for-each>
          </xsl:when>

          <xsl:otherwise>
            <xsl:value-of select="$data" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
