<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:hl7typ="urn:esr-vha-gov:internal:xslt:hl7-types" 
    xmlns:utl="urn:esr-vha-gov:internal:xslt:utilities" 
    extension-element-prefixes="hl7typ utl" 
    xmlns:wns="urn:esr-vha-gov:internal:working-namespace" 
    exclude-result-prefixes="wns" 
    xmlns="urn:esr-vha-gov:internal:hl7-messages">
<!--	
  <xsl:import href="edb/messaging/hl7/xslt/Utilities.xslt" />
-->
  <xsl:variable name="hl7typ:standardSegmentDelimiter" select="'&#x0D;'" />
  <xsl:variable name="hl7typ:standardFieldDelimiter" select="'|'" />
  <xsl:variable name="hl7typ:standardComponentDelimiter" select="'^'" />
  <xsl:variable name="hl7typ:standardSubComponentDelimiter" select="'&amp;'" />
  <xsl:variable name="hl7typ:standardRepeatingFieldDelimiter" select="'~'" />
  <xsl:variable name="hl7typ:standardEscapeCharacter" select="'\'" />

  <xsl:variable name="hl7typ:standardDelimiters" select="concat($hl7typ:standardFieldDelimiter, $hl7typ:standardRepeatingFieldDelimiter, $hl7typ:standardComponentDelimiter, $hl7typ:standardSubComponentDelimiter)" />

  <xsl:namespace-alias stylesheet-prefix="wns" result-prefix="#default" />

  <!--**********************************************************************-->
  <!--************************* Base Templates *****************************-->
  <xsl:template name="hl7typ:nullableType">
    <xsl:param name="dataString" />

    <xsl:choose>
      <xsl:when test="$dataString = '&quot;&quot;'"></xsl:when>
      <xsl:otherwise><xsl:value-of select="$dataString" /></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="hl7typ:simpleType.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:variable name="dataString">
      <xsl:call-template name="utl:combine">
        <xsl:with-param name="data" select="$data" />
        <xsl:with-param name="delimiters" select="$hl7typ:standardDelimiters" />
        <xsl:with-param name="defaultDelimiter" select="''" />
      </xsl:call-template>
    </xsl:variable>

    <xsl:if test="$dataString != ''">
      <xsl:element name="{$elementName}">
        <xsl:call-template name="hl7typ:nullableType">
          <xsl:with-param name="dataString" select="$dataString" />
        </xsl:call-template>
      </xsl:element>
    </xsl:if>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* AD ***********************************-->
  <xsl:template name="hl7typ:ad.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:ad.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:ad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ad.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:ad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ad.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:ad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ad.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4 | wns:s.4" mode="hl7typ:ad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ad.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5 | wns:s.5" mode="hl7typ:ad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ad.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6 | wns:s.6" mode="hl7typ:ad.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'ad.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.7 | wns:s.7" mode="hl7typ:ad.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'ad.7'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.8 | wns:s.8" mode="hl7typ:ad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ad.8'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:ad.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('ad.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* CE ***********************************-->
  <xsl:template name="hl7typ:ce.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:ce.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:ce.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ce.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:ce.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ce.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:ce.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ce.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4 | wns:s.4" mode="hl7typ:ce.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ce.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5 | wns:s.5" mode="hl7typ:ce.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ce.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6 | wns:s.6" mode="hl7typ:ce.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ce.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:ce.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('ce.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* CF ***********************************-->
  <xsl:template name="hl7typ:cf.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:cf.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:cf.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cf.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:cf.components">
    <xsl:call-template name="hl7typ:ft.element">
      <xsl:with-param name="elementName" select="'cf.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:cf.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cf.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4 | wns:s.4" mode="hl7typ:cf.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cf.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5 | wns:s.5" mode="hl7typ:cf.components">
    <xsl:call-template name="hl7typ:ft.element">
      <xsl:with-param name="elementName" select="'cf.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6 | wns:s.6" mode="hl7typ:cf.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cf.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:cf.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('cf.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* CK ***********************************-->
  <xsl:template name="hl7typ:ck.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:ck.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:ck.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'ck.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:ck.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'ck.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3" mode="hl7typ:ck.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'ck.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4" mode="hl7typ:ck.components">
    <xsl:call-template name="hl7typ:hd.element">
      <xsl:with-param name="elementName" select="'ck.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:ck.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('ck.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* CN ***********************************-->
  <xsl:template name="hl7typ:cn.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:cn.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:cn.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'cn.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:cn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cn.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3" mode="hl7typ:cn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cn.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4" mode="hl7typ:cn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cn.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5" mode="hl7typ:cn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cn.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6" mode="hl7typ:cn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cn.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.7" mode="hl7typ:cn.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'cn.7'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.8" mode="hl7typ:cn.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'cn.8'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.9" mode="hl7typ:cn.components">
    <xsl:call-template name="hl7typ:hd.element">
      <xsl:with-param name="elementName" select="'cn.9'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:cn.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('cn.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* CNE **********************************-->
  <xsl:template name="hl7typ:cne.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:cne.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:cne.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cne.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:cne.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cne.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:cne.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cne.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4 | wns:s.4" mode="hl7typ:cne.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cne.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5 | wns:s.5" mode="hl7typ:cne.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cne.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6 | wns:s.6" mode="hl7typ:cne.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cne.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.7 | wns:s.7" mode="hl7typ:cne.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cne.7'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.8 | wns:s.8" mode="hl7typ:cne.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cne.8'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.9 | wns:s.9" mode="hl7typ:cne.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cne.9'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:cne.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('cne.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* CP ***********************************-->
  <xsl:template name="hl7typ:cp.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:cp.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:cp.components">
    <xsl:call-template name="hl7typ:mo.element">
      <xsl:with-param name="elementName" select="'cp.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:cp.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'cp.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3" mode="hl7typ:cp.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'cp.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4" mode="hl7typ:cp.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'cp.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5" mode="hl7typ:cp.components">
    <xsl:call-template name="hl7typ:ce.element">
      <xsl:with-param name="elementName" select="'cp.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6" mode="hl7typ:cp.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'cp.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:cp.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('cp.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* CQ ***********************************-->
  <xsl:template name="hl7typ:cq.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:cq.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:cq.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'cq.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:cq.components">
    <xsl:call-template name="hl7typ:ce.element">
      <xsl:with-param name="elementName" select="'cq.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:cq.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('cq.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* CWE **********************************-->
  <xsl:template name="hl7typ:cwe.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:cwe.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:cwe.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cwe.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:cwe.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cwe.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:cwe.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cwe.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4 | wns:s.4" mode="hl7typ:cwe.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cwe.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5 | wns:s.5" mode="hl7typ:cwe.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cwe.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6 | wns:s.6" mode="hl7typ:cwe.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cwe.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.7 | wns:s.7" mode="hl7typ:cwe.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cwe.7'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.8 | wns:s.8" mode="hl7typ:cwe.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cwe.8'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.9 | wns:s.9" mode="hl7typ:cwe.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cwe.9'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:cwe.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('cwe.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* CX ***********************************-->
  <xsl:template name="hl7typ:cx.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:cx.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:cx.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cx.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:cx.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'cx.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3" mode="hl7typ:cx.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'cx.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4" mode="hl7typ:cx.components">
    <xsl:call-template name="hl7typ:hd.element">
      <xsl:with-param name="elementName" select="'cx.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5" mode="hl7typ:cx.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'cx.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6" mode="hl7typ:cx.components">
    <xsl:call-template name="hl7typ:hd.element">
      <xsl:with-param name="elementName" select="'cx.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:cx.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('cx.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* DLN **********************************-->
  <xsl:template name="hl7typ:dln.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:dln.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:dln.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'dln.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:dln.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'dln.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:dln.components">
    <xsl:call-template name="hl7typ:dt.element">
      <xsl:with-param name="elementName" select="'dln.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:dln.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('dln.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* DR ***********************************-->
  <xsl:template name="hl7typ:dr.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:dr.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:dr.components">
    <xsl:call-template name="hl7typ:ts.element">
      <xsl:with-param name="elementName" select="'dr.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:dr.components">
    <xsl:call-template name="hl7typ:ts.element">
      <xsl:with-param name="elementName" select="'dr.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:dr.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('dr.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* DT ***********************************-->
  <xsl:template name="hl7typ:dt.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="$elementName" />
      <xsl:with-param name="data" select="$data" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* EI ***********************************-->
  <xsl:template name="hl7typ:ei.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:ei.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:ei.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ei.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:ei.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'ei.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:ei.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ei.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4 | wns:s.4" mode="hl7typ:ei.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'ei.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:ei.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('ei.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* FT ***********************************-->
  <xsl:template name="hl7typ:ft.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="$elementName" />
      <xsl:with-param name="data" select="$data" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* HD ***********************************-->
  <xsl:template name="hl7typ:hd.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:hd.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:hd.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'hd.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:hd.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'hd.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:hd.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'hd.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:hd.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('hd.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* ID ***********************************-->
  <xsl:template name="hl7typ:id.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="$elementName" />
      <xsl:with-param name="data" select="$data" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* IS ***********************************-->
  <xsl:template name="hl7typ:is.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="$elementName" />
      <xsl:with-param name="data" select="$data" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* MO ***********************************-->
  <xsl:template name="hl7typ:mo.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:mo.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:mo.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'mo.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:mo.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'mo.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:mo.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('mo.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* NM ***********************************-->
  <xsl:template name="hl7typ:nm.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="$elementName" />
      <xsl:with-param name="data" select="$data" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* PL ***********************************-->
  <xsl:template name="hl7typ:pl.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:pl.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:pl.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'pl.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:pl.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'pl.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3" mode="hl7typ:pl.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'pl.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4" mode="hl7typ:pl.components">
    <xsl:call-template name="hl7typ:hd.element">
      <xsl:with-param name="elementName" select="'pl.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5" mode="hl7typ:pl.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'pl.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6" mode="hl7typ:pl.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'pl.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.7" mode="hl7typ:pl.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'pl.7'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.8" mode="hl7typ:pl.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'pl.8'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.9" mode="hl7typ:pl.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'pl.9'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:pl.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('pl.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* PN ***********************************-->
  <xsl:template name="hl7typ:pn.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:pn.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:pn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'pn.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:pn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'pn.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:pn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'pn.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4 | wns:s.4" mode="hl7typ:pn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'pn.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5 | wns:s.5" mode="hl7typ:pn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'pn.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6 | wns:s.6" mode="hl7typ:pn.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'pn.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:pn.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('pn.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* PT ***********************************-->
  <xsl:template name="hl7typ:pt.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:pt.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:pt.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'pt.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:pt.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'pt.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:pt.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('pt.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* RP ***********************************-->
  <xsl:template name="hl7typ:rp.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:rp.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:rp.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'rp.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:rp.components">
    <xsl:call-template name="hl7typ:hd.element">
      <xsl:with-param name="elementName" select="'rp.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3" mode="hl7typ:rp.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'rp.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4" mode="hl7typ:rp.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'rp.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:rp.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('rp.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* SI ***********************************-->
  <xsl:template name="hl7typ:si.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="$elementName" />
      <xsl:with-param name="data" select="$data" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* SN ***********************************-->
  <xsl:template name="hl7typ:sn.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:sn.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:sn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'sn.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:sn.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'sn.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:sn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'sn.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4 | wns:s.4" mode="hl7typ:sn.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'sn.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:sn.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('sn.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* ST ***********************************-->
  <xsl:template name="hl7typ:st.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="$elementName" />
      <xsl:with-param name="data" select="$data" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* TM ***********************************-->
  <xsl:template name="hl7typ:tm.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="$elementName" />
      <xsl:with-param name="data" select="$data" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* TN ***********************************-->
  <xsl:template name="hl7typ:tn.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="$elementName" />
      <xsl:with-param name="data" select="$data" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* TS ***********************************-->
  <xsl:template name="hl7typ:ts.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:ts.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:ts.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="'ts.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:ts.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'ts.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:ts.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('ts.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* TX ***********************************-->
  <xsl:template name="hl7typ:tx.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="$elementName" />
      <xsl:with-param name="data" select="$data" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* VID **********************************-->
  <xsl:template name="hl7typ:vid.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:vid.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:vid.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'vid.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:vid.components">
    <xsl:call-template name="hl7typ:ce.element">
      <xsl:with-param name="elementName" select="'vid.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3" mode="hl7typ:vid.components">
    <xsl:call-template name="hl7typ:ce.element">
      <xsl:with-param name="elementName" select="'vid.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:vid.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('vid.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* XAD **********************************-->
  <xsl:template name="hl7typ:xad.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:xad.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xad.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xad.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xad.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4 | wns:s.4" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xad.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5 | wns:s.5" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xad.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6 | wns:s.6" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xad.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.7 | wns:s.7" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xad.7'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.8 | wns:s.8" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xad.8'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.9 | wns:s.9" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'xad.9'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.10 | wns:s.10" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'xad.10'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.11 | wns:s.11" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xad.11'" />
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template match="wns:c.12 | wns:s.12" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xad.12'" />
    </xsl:call-template>
  </xsl:template>  

  <xsl:template match="wns:*" mode="hl7typ:xad.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('xad.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* XCN **********************************-->
  <xsl:template name="hl7typ:xcn.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:xcn.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'xcn.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xcn.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xcn.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xcn.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xcn.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xcn.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.7" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'xcn.7'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.8" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'xcn.8'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.9" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:hd.element">
      <xsl:with-param name="elementName" select="'xcn.9'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.10" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xcn.10'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.11" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xcn.11'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.12" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xcn.12'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.13" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'xcn.13'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.14" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:hd.element">
      <xsl:with-param name="elementName" select="'xcn.14'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.15" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xcn.15'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:xcn.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('xcn.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* XON **********************************-->
  <xsl:template name="hl7typ:xon.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:xon.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:xon.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xon.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:xon.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'xon.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3" mode="hl7typ:xon.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xon.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4" mode="hl7typ:xon.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'xon.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5" mode="hl7typ:xon.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xon.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6" mode="hl7typ:xon.components">
    <xsl:call-template name="hl7typ:hd.element">
      <xsl:with-param name="elementName" select="'xon.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.7" mode="hl7typ:xon.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'xon.7'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.8" mode="hl7typ:xon.components">
    <xsl:call-template name="hl7typ:hd.element">
      <xsl:with-param name="elementName" select="'xon.8'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.9" mode="hl7typ:xon.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xon.9'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:xon.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('xon.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* XPN **********************************-->
  <xsl:template name="hl7typ:xpn.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:xpn.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:xpn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xpn.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:xpn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xpn.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:xpn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xpn.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4 | wns:s.4" mode="hl7typ:xpn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xpn.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5 | wns:s.5" mode="hl7typ:xpn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xpn.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6 | wns:s.6" mode="hl7typ:xpn.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'xpn.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.7 | wns:s.7" mode="hl7typ:xpn.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xpn.7'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.8 | wns:s.8" mode="hl7typ:xpn.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xpn.8'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:xpn.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('xpn.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* XTN **********************************-->
  <xsl:template name="hl7typ:xtn.element">
    <xsl:param name="elementName" select="local-name()" />
    <xsl:param name="data" select="." />

    <xsl:element name="{$elementName}">
      <xsl:apply-templates mode="hl7typ:xtn.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1 | wns:s.1" mode="hl7typ:xtn.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="'xtn.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2 | wns:s.2" mode="hl7typ:xtn.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xtn.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3 | wns:s.3" mode="hl7typ:xtn.components">
    <xsl:call-template name="hl7typ:id.element">
      <xsl:with-param name="elementName" select="'xtn.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.4 | wns:s.4" mode="hl7typ:xtn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xtn.4'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.5 | wns:s.5" mode="hl7typ:xtn.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'xtn.5'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.6 | wns:s.6" mode="hl7typ:xtn.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'xtn.6'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.7 | wns:s.7" mode="hl7typ:xtn.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'xtn.7'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.8 | wns:s.8" mode="hl7typ:xtn.components">
    <xsl:call-template name="hl7typ:nm.element">
      <xsl:with-param name="elementName" select="'xtn.8'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.9 | wns:s.9" mode="hl7typ:xtn.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'xtn.9'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:xtn.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('xtn.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>
</xsl:stylesheet>
