<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:hl7seg="urn:esr-vha-gov:internal:xslt:hl7-segments" 
    xmlns:hl7typ="urn:esr-vha-gov:internal:xslt:hl7-types" 
    extension-element-prefixes="hl7seg hl7typ" 
    xmlns:wns="urn:esr-vha-gov:internal:working-namespace" 
    exclude-result-prefixes="wns" 
    xmlns="urn:esr-vha-gov:internal:hl7-messages">
<!--	
  <xsl:import href="edb/messaging/hl7/xslt/HL7Types.xslt" />
-->
  <!--**********************************************************************-->
  <!--******************************* BHS **********************************-->
  <xsl:template match="wns:bhs" mode="hl7typ:segments">
    <xsl:param name="fieldDelimiter" />
    <xsl:param name="componentDelimiter" />
    <xsl:param name="subComponentDelimiter" />
    <xsl:param name="repeatingFieldDelimiter" />
    <xsl:param name="escapeCharacter" />

    <xsl:element name="bhs">
      <!-- Encoding Attributes -->
      <xsl:attribute name="fieldDelimiter"><xsl:value-of select="$fieldDelimiter" /></xsl:attribute>
      <xsl:attribute name="componentDelimiter"><xsl:value-of select="$componentDelimiter" /></xsl:attribute>
      <xsl:attribute name="subComponentDelimiter"><xsl:value-of select="$subComponentDelimiter" /></xsl:attribute>
      <xsl:attribute name="repeatingFieldDelimiter"><xsl:value-of select="$repeatingFieldDelimiter" /></xsl:attribute>
      <xsl:attribute name="escapeCharacter"><xsl:value-of select="$escapeCharacter" /></xsl:attribute>

      <xsl:apply-templates mode="hl7typ:fields" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:bhs.1" mode="hl7typ:fields" />

  <xsl:template match="wns:bhs.2" mode="hl7typ:fields" />

  <xsl:template match="wns:bhs.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:bhs.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:bhs.5" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:bhs.6" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:bhs.7" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:bhs.8" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:bhs.9" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:bhs.10" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:bhs.11" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:bhs.12" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* BTS **********************************-->
  <xsl:template match="wns:bts.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:bts.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:bts.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:nm.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* FT1 **********************************-->

  <!--**********************************************************************-->
  <!--******************************* IN1 **********************************-->
  <xsl:template match="wns:in1.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:si.element" />
  </xsl:template>

  <xsl:template match="wns:in1.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:in1.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cx.element" />
  </xsl:template>

  <xsl:template match="wns:in1.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xon.element" />
  </xsl:template>

  <xsl:template match="wns:in1.5" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xad.element" />
  </xsl:template>

  <xsl:template match="wns:in1.6" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xpn.element" />
  </xsl:template>

  <xsl:template match="wns:in1.7" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xtn.element" />
  </xsl:template>

  <xsl:template match="wns:in1.8" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:in1.9" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xon.element" />
  </xsl:template>

  <xsl:template match="wns:in1.10" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cx.element" />
  </xsl:template>

  <xsl:template match="wns:in1.11" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xon.element" />
  </xsl:template>

  <xsl:template match="wns:in1.12" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:dt.element" />
  </xsl:template>

  <xsl:template match="wns:in1.13" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:dt.element" />
  </xsl:template>

  <xsl:template match="wns:in1.14" mode="hl7typ:fields">
    <xsl:element name="{local-name()}">
      <xsl:apply-templates mode="hl7typ:in1.14.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:in1.14.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'in1.14.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:in1.14.components">
    <xsl:call-template name="hl7typ:dt.element">
      <xsl:with-param name="elementName" select="'in1.14.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3" mode="hl7typ:in1.14.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'in1.14.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:in1.14.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('in1.14.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:in1.15" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:in1.16" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xpn.element" />
  </xsl:template>

  <xsl:template match="wns:in1.17" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:in1.18" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:in1.19" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xad.element" />
  </xsl:template>

  <xsl:template match="wns:in1.20" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:in1.21" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:in1.22" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:in1.23" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:in1.24" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:dt.element" />
  </xsl:template>

  <xsl:template match="wns:in1.25" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:in1.26" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:dt.element" />
  </xsl:template>

  <xsl:template match="wns:in1.27" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:in1.28" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:in1.29" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:in1.30" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xcn.element" />
  </xsl:template>

  <xsl:template match="wns:in1.31" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:in1.32" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:in1.33" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:nm.element" />
  </xsl:template>

  <xsl:template match="wns:in1.34" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:nm.element" />
  </xsl:template>

  <xsl:template match="wns:in1.35" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:in1.36" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:in1.37" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cp.element" />
  </xsl:template>

  <xsl:template match="wns:in1.38" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cp.element" />
  </xsl:template>

  <xsl:template match="wns:in1.39" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:nm.element" />
  </xsl:template>

  <xsl:template match="wns:in1.40" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cp.element" />
  </xsl:template>

  <xsl:template match="wns:in1.41" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cp.element" />
  </xsl:template>

  <xsl:template match="wns:in1.42" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:in1.43" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:in1.44" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xad.element" />
  </xsl:template>

  <xsl:template match="wns:in1.45" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:in1.46" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:in1.47" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:in1.48" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:in1.49" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cx.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* MFA **********************************-->
   <xsl:template match="wns:mfa.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:mfa.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:mfa.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:mfa.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:mfa.5" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:mfa.6" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>
 
  <!--**********************************************************************-->
  <!--******************************* MFE **********************************-->
   <xsl:template match="wns:mfe.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:mfe.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:mfe.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:mfe.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:mfe.5" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* MFI **********************************-->
   <xsl:template match="wns:mfi.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:mfi.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:hd.element" />
  </xsl:template>

  <xsl:template match="wns:mfi.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:mfi.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:mfi.5" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:mfi.6" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* MSA **********************************-->
  <xsl:template match="wns:msa.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:msa.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:msa.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:msa.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:nm.element" />
  </xsl:template>

  <xsl:template match="wns:msa.5" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:msa.6" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* MSH **********************************-->
  <xsl:template match="wns:msh" mode="hl7typ:segments">
    <xsl:param name="fieldDelimiter" />
    <xsl:param name="componentDelimiter" />
    <xsl:param name="subComponentDelimiter" />
    <xsl:param name="repeatingFieldDelimiter" />
    <xsl:param name="escapeCharacter" />

    <xsl:element name="msh">
      <!-- Encoding Attributes -->
      <xsl:attribute name="fieldDelimiter"><xsl:value-of select="$fieldDelimiter" /></xsl:attribute>
      <xsl:attribute name="componentDelimiter"><xsl:value-of select="$componentDelimiter" /></xsl:attribute>
      <xsl:attribute name="subComponentDelimiter"><xsl:value-of select="$subComponentDelimiter" /></xsl:attribute>
      <xsl:attribute name="repeatingFieldDelimiter"><xsl:value-of select="$repeatingFieldDelimiter" /></xsl:attribute>
      <xsl:attribute name="escapeCharacter"><xsl:value-of select="$escapeCharacter" /></xsl:attribute>

      <xsl:apply-templates mode="hl7typ:fields" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:msh.1" mode="hl7typ:fields" />

  <xsl:template match="wns:msh.2" mode="hl7typ:fields" />

  <xsl:template match="wns:msh.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:hd.element" />
  </xsl:template>

  <xsl:template match="wns:msh.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:hd.element" />
  </xsl:template>

  <xsl:template match="wns:msh.5" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:hd.element" />
  </xsl:template>

  <xsl:template match="wns:msh.6" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:hd.element" />
  </xsl:template>

  <xsl:template match="wns:msh.7" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:msh.8" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:msh.9" mode="hl7typ:fields">
    <xsl:element name="{local-name()}">
      <xsl:apply-templates mode="hl7typ:msh.9.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:msh.9.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'msh.9.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:msh.9.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'msh.9.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.3" mode="hl7typ:msh.9.components">
    <xsl:call-template name="hl7typ:is.element">
      <xsl:with-param name="elementName" select="'msh.9.3'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:msh.9.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('msh.9.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:msh.10" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:msh.11" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:pt.element" />
  </xsl:template>

  <xsl:template match="wns:msh.12" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:vid.element" />
  </xsl:template>

  <xsl:template match="wns:msh.13" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:nm.element" />
  </xsl:template>

  <xsl:template match="wns:msh.14" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:msh.15" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:msh.16" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:msh.17" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:msh.18" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:msh.19" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:msh.20" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* NTE **********************************-->
  <xsl:template match="wns:nte.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:si.element" />
  </xsl:template>

  <xsl:template match="wns:nte.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:nte.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ft.element" />
  </xsl:template>

  <xsl:template match="wns:nte.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* OBX **********************************-->
  <xsl:template match="wns:obx.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:si.element" />
  </xsl:template>

  <xsl:template match="wns:obx.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:obx.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:obx.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:obx.5" mode="hl7typ:fields">
    <xsl:variable name="type" select="../wns:obx.2" />

    <xsl:choose>
      <xsl:when test="$type = 'AD'">
        <xsl:call-template name="hl7typ:ad.element" />
      </xsl:when>
      <xsl:when test="$type = 'CE'">
        <xsl:call-template name="hl7typ:ce.element" />
      </xsl:when>
      <xsl:when test="$type = 'CF'">
        <xsl:call-template name="hl7typ:cf.element" />
      </xsl:when>
      <xsl:when test="$type = 'CK'">
        <xsl:call-template name="hl7typ:ck.element" />
      </xsl:when>
      <xsl:when test="$type = 'CN'">
        <xsl:call-template name="hl7typ:cn.element" />
      </xsl:when>
      <xsl:when test="$type = 'CP'">
        <xsl:call-template name="hl7typ:cp.element" />
      </xsl:when>
      <xsl:when test="$type = 'CX'">
        <xsl:call-template name="hl7typ:cx.element" />
      </xsl:when>
      <xsl:when test="$type = 'DT'">
        <xsl:call-template name="hl7typ:dt.element" />
      </xsl:when>
      <!--<xsl:when test="$type = 'ed'">
        <xsl:call-template name="hl7typ:ed.element" />
      </xsl:when>-->
      <xsl:when test="$type = 'FT'">
        <xsl:call-template name="hl7typ:ft.element" />
      </xsl:when>
      <xsl:when test="$type = 'MO'">
        <xsl:call-template name="hl7typ:mo.element" />
      </xsl:when>
      <xsl:when test="$type = 'NM'">
        <xsl:call-template name="hl7typ:nm.element" />
      </xsl:when>
      <xsl:when test="$type = 'PN'">
        <xsl:call-template name="hl7typ:pn.element" />
      </xsl:when>
      <xsl:when test="$type = 'RP'">
        <xsl:call-template name="hl7typ:rp.element" />
      </xsl:when>
      <xsl:when test="$type = 'SN'">
        <xsl:call-template name="hl7typ:sn.element" />
      </xsl:when>
      <xsl:when test="$type = 'ST'">
        <xsl:call-template name="hl7typ:st.element" />
      </xsl:when>
      <xsl:when test="$type = 'TM'">
        <xsl:call-template name="hl7typ:tm.element" />
      </xsl:when>
      <xsl:when test="$type = 'TN'">
        <xsl:call-template name="hl7typ:tn.element" />
      </xsl:when>
      <xsl:when test="$type = 'TS'">
        <xsl:call-template name="hl7typ:ts.element" />
      </xsl:when>
      <xsl:when test="$type = 'TX'">
        <xsl:call-template name="hl7typ:tx.element" />
      </xsl:when>
      <xsl:when test="$type = 'XAD'">
        <xsl:call-template name="hl7typ:xad.element" />
      </xsl:when>
      <xsl:when test="$type = 'XCN'">
        <xsl:call-template name="hl7typ:xcn.element" />
      </xsl:when>
      <xsl:when test="$type = 'XON'">
        <xsl:call-template name="hl7typ:xon.element" />
      </xsl:when>
      <xsl:when test="$type = 'XPN'">
        <xsl:call-template name="hl7typ:xpn.element" />
      </xsl:when>
      <xsl:when test="$type = 'XTN'">
        <xsl:call-template name="hl7typ:xtn.element" />
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="wns:obx.6" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:obx.7" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:obx.8" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:obx.9" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:nm.element" />
  </xsl:template>

  <xsl:template match="wns:obx.10" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:obx.11" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:obx.12" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:obx.13" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:obx.14" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:obx.15" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:obx.16" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xcn.element" />
  </xsl:template>

  <xsl:template match="wns:obx.17" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* PD1 **********************************-->
  <xsl:template match="wns:pd1.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:pd1.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:pd1.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xon.element" />
  </xsl:template>

  <xsl:template match="wns:pd1.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xcn.element" />
  </xsl:template>

  <xsl:template match="wns:pd1.5" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:pd1.6" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:pd1.7" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:pd1.8" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:pd1.9" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:pd1.10" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cx.element" />
  </xsl:template>

  <xsl:template match="wns:pd1.11" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:pd1.12" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* PID **********************************-->
  <xsl:template match="wns:pid.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:si.element" />
  </xsl:template>

  <xsl:template match="wns:pid.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cx.element" />
  </xsl:template>

  <xsl:template match="wns:pid.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cx.element" />
  </xsl:template>

  <xsl:template match="wns:pid.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cx.element" />
  </xsl:template>

  <xsl:template match="wns:pid.5" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xpn.element" />
  </xsl:template>

  <xsl:template match="wns:pid.6" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xpn.element" />
  </xsl:template>

  <xsl:template match="wns:pid.7" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:pid.8" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:pid.9" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xpn.element" />
  </xsl:template>

  <xsl:template match="wns:pid.10" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:pid.11" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xad.element" />
  </xsl:template>

  <xsl:template match="wns:pid.12" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:is.element" />
  </xsl:template>

  <xsl:template match="wns:pid.13" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xtn.element" />
  </xsl:template>

  <xsl:template match="wns:pid.14" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xtn.element" />
  </xsl:template>

  <xsl:template match="wns:pid.15" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:pid.16" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:pid.17" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:pid.18" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cx.element" />
  </xsl:template>

  <xsl:template match="wns:pid.19" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:pid.20" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:dln.element" />
  </xsl:template>

  <xsl:template match="wns:pid.21" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cx.element" />
  </xsl:template>

  <xsl:template match="wns:pid.22" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:pid.23" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:pid.24" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:pid.25" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:nm.element" />
  </xsl:template>

  <xsl:template match="wns:pid.26" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:pid.27" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:pid.28" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:pid.29" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:pid.30" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* QRD **********************************-->
  <xsl:template match="wns:qrd.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:qrd.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:qrd.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:qrd.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:qrd.5" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:qrd.6" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:qrd.7" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:cq.element" />
  </xsl:template>

  <xsl:template match="wns:qrd.8" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:xcn.element" />
  </xsl:template>

  <xsl:template match="wns:qrd.9" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:qrd.10" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:qrd.11" mode="hl7typ:fields">
    <xsl:element name="{local-name()}">
      <xsl:apply-templates mode="hl7typ:qrd.11.components" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:c.1" mode="hl7typ:qrd.11.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'qrd.11.1'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:c.2" mode="hl7typ:qrd.11.components">
    <xsl:call-template name="hl7typ:st.element">
      <xsl:with-param name="elementName" select="'qrd.11.2'" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:qrd.11.components">
    <xsl:call-template name="hl7typ:simpleType.element">
      <xsl:with-param name="elementName" select="concat('qrd.11.', substring-after(local-name(), '.'))" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wns:qrd.12" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* QRF **********************************-->
  <xsl:template match="wns:qrf.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:qrf.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:qrf.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:qrf.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:qrf.5" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:st.element" />
  </xsl:template>

  <xsl:template match="wns:qrf.6" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:qrf.7" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <xsl:template match="wns:qrf.8" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:id.element" />
  </xsl:template>

  <!--<xsl:template match="wns:qrf.9" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:tq.element" />
  </xsl:template>-->
  <xsl:template match="wns:qrf.9" mode="hl7typ:fields">
    <xsl:attribute name="{local-name()}">
      <xsl:value-of select="." />
    </xsl:attribute>
  </xsl:template>

  <!--**********************************************************************-->
  <!--******************************* RF1 **********************************-->
  <xsl:template match="wns:rf1.1" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:rf1.2" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:rf1.3" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:rf1.4" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:rf1.5" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:rf1.6" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ei.element" />
  </xsl:template>

  <xsl:template match="wns:rf1.7" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:rf1.8" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:rf1.9" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ts.element" />
  </xsl:template>

  <xsl:template match="wns:rf1.10" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ce.element" />
  </xsl:template>

  <xsl:template match="wns:rf1.11" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:ei.element" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--***************************** Default ********************************-->
  <xsl:template match="wns:*" mode="hl7typ:segments">
    <xsl:param name="fieldDelimiter" />
    <xsl:param name="componentDelimiter" />
    <xsl:param name="subComponentDelimiter" />
    <xsl:param name="repeatingFieldDelimiter" />
    <xsl:param name="escapeCharacter" />

    <xsl:element name="{local-name()}">
      <xsl:apply-templates mode="hl7typ:fields" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="wns:*" mode="hl7typ:fields">
    <xsl:call-template name="hl7typ:simpleType.element" />
  </xsl:template>
</xsl:stylesheet>
