<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:hl7msg="urn:esr-vha-gov:internal:xslt:hl7-messages" 
    xmlns:hl7typ="urn:esr-vha-gov:internal:xslt:hl7-types" 
    xmlns:utl="urn:esr-vha-gov:internal:xslt:utilities" 
    xmlns:node="http://xml.apache.org/xalan" 
    extension-element-prefixes="hl7msg hl7typ utl node" 
    xmlns:wns="urn:esr-vha-gov:internal:working-namespace" 
    xmlns:msg="Message" 
    exclude-result-prefixes="wns msg" 
    xmlns="urn:esr-vha-gov:internal:hl7-messages" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<!--	
  <xsl:import href="edb/messaging/hl7/xslt/HL7Types.xslt" />
  <xsl:import href="edb/messaging/hl7/xslt/Utilities.xslt" />
-->
  <xsl:param name="hl7msg:schemaLocation" />

  <!--**********************************************************************-->
  <!--*********************** Encoding Characters **************************-->
  <xsl:template name="hl7msg:fieldDelimiter">
    <xsl:value-of select="substring(/*, 4, 1)" />
  </xsl:template>

  <xsl:template name="hl7msg:componentDelimiter">
    <xsl:value-of select="substring(/*, 5, 1)" />
  </xsl:template>

  <xsl:template name="hl7msg:subComponentDelimiter">
    <xsl:value-of select="substring(/*, 8, 1)" />
  </xsl:template>

  <xsl:template name="hl7msg:repeatingFieldDelimiter">
    <xsl:value-of select="substring(/*, 6, 1)" />
  </xsl:template>

  <xsl:template name="hl7msg:escapeCharacter">
    <xsl:value-of select="substring(/*, 7, 1)" />
  </xsl:template>

  <!--**********************************************************************-->
  <!--************************** Nested Split ******************************-->
  <xsl:template name="hl7msg:nestedSplit.segment">
    <xsl:param name="dataString" />
    <xsl:param name="delimiters" />

    <xsl:variable name="tokenString">
      <xsl:call-template name="utl:split">
        <xsl:with-param name="dataString" select="translate($dataString, '&#x0A;', $hl7typ:standardSegmentDelimiter)" />
        <xsl:with-param name="delimiter" select="$hl7typ:standardSegmentDelimiter" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="tokens" select="node:nodeset($tokenString)" />

    <xsl:element name="wns:message">
      <xsl:for-each select="$tokens/*">
        <xsl:if test=". != ''">
          <xsl:variable name="segmentName" select="translate(substring(., 1, 3), 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')" />

          <xsl:call-template name="hl7msg:nestedSplit.field">
            <xsl:with-param name="segmentName" select="$segmentName" />
            <xsl:with-param name="dataString">
              <xsl:choose>
                <xsl:when test="($segmentName = 'bhs') or ($segmentName = 'msh')">
                  <xsl:value-of select="concat($hl7typ:standardFieldDelimiter, translate(substring(., 9), $delimiters, $hl7typ:standardDelimiters))" />
                </xsl:when>

                <xsl:otherwise>
                  <xsl:value-of select="translate(substring(., 5), $delimiters, $hl7typ:standardDelimiters)" />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:if>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>

  <xsl:template name="hl7msg:nestedSplit.field">
    <xsl:param name="segmentName" />
    <xsl:param name="dataString" />

    <xsl:variable name="tokenString">
      <xsl:call-template name="utl:split">
        <xsl:with-param name="dataString" select="$dataString" />
        <xsl:with-param name="delimiter" select="$hl7typ:standardFieldDelimiter" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="tokens" select="node:nodeset($tokenString)" />

    <xsl:element name="{concat('wns:', $segmentName)}">
      <xsl:for-each select="$tokens/*">
        <xsl:if test=". != ''">
          <xsl:call-template name="hl7msg:nestedSplit.repeating">
            <xsl:with-param name="fieldName" select="concat('wns:', $segmentName, '.', position())" />
            <xsl:with-param name="dataString" select="." />
          </xsl:call-template>
        </xsl:if>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>

  <xsl:template name="hl7msg:nestedSplit.repeating">
    <xsl:param name="fieldName" />
    <xsl:param name="dataString" />

    <xsl:variable name="tokenString">
      <xsl:call-template name="utl:split">
        <xsl:with-param name="dataString" select="$dataString" />
        <xsl:with-param name="delimiter" select="$hl7typ:standardRepeatingFieldDelimiter" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="tokens" select="node:nodeset($tokenString)" />

    <xsl:for-each select="$tokens/*">
      <xsl:if test=". != ''">
        <xsl:element name="{$fieldName}">
          <xsl:call-template name="hl7msg:nestedSplit.component">
            <xsl:with-param name="dataString" select="." />
          </xsl:call-template>
        </xsl:element>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="hl7msg:nestedSplit.component">
    <xsl:param name="dataString" />

    <xsl:variable name="tokenString">
      <xsl:call-template name="utl:split">
        <xsl:with-param name="dataString" select="$dataString" />
        <xsl:with-param name="delimiter" select="$hl7typ:standardComponentDelimiter" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="tokens" select="node:nodeset($tokenString)" />

    <xsl:for-each select="$tokens/*">
      <xsl:if test=". != ''">
        <xsl:element name="{concat('wns:c.', position())}">
          <xsl:call-template name="hl7msg:nestedSplit.subComponent">
            <xsl:with-param name="dataString" select="." />
          </xsl:call-template>
        </xsl:element>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="hl7msg:nestedSplit.subComponent">
    <xsl:param name="dataString" />

    <xsl:variable name="tokenString">
      <xsl:call-template name="utl:split">
        <xsl:with-param name="dataString" select="$dataString" />
        <xsl:with-param name="delimiter" select="$hl7typ:standardSubComponentDelimiter" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="tokens" select="node:nodeset($tokenString)" />

    <xsl:for-each select="$tokens/*">
      <xsl:if test=". != ''">
        <xsl:element name="{concat('wns:s.', position())}">
          <xsl:value-of select="." />
        </xsl:element>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <!--**********************************************************************-->
  <!--************************** Root Templates ****************************-->
  <xsl:template match="msg:message">
    <xsl:param name="messageName" />
    <xsl:param name="isBatch" select="false()" />

    <xsl:variable name="fieldDelimiter">
      <xsl:call-template name="hl7msg:fieldDelimiter" />
    </xsl:variable>
    <xsl:variable name="componentDelimiter">
      <xsl:call-template name="hl7msg:componentDelimiter" />
    </xsl:variable>
    <xsl:variable name="subComponentDelimiter">
      <xsl:call-template name="hl7msg:subComponentDelimiter" />
    </xsl:variable>
    <xsl:variable name="repeatingFieldDelimiter">
      <xsl:call-template name="hl7msg:repeatingFieldDelimiter" />
    </xsl:variable>
    <xsl:variable name="escapeCharacter">
      <xsl:call-template name="hl7msg:escapeCharacter" />
    </xsl:variable>
    <xsl:variable name="delimiters" select="concat($fieldDelimiter, $repeatingFieldDelimiter, $componentDelimiter, $subComponentDelimiter)" />

    <xsl:variable name="dataString">
      <xsl:call-template name="hl7msg:nestedSplit.segment">
        <xsl:with-param name="dataString" select="." />
        <xsl:with-param name="delimiters" select="$delimiters" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="data" select="node:nodeset($dataString)" />

    <xsl:element name="{$messageName}">
      <xsl:attribute name="xsi:schemaLocation">urn:esr-vha-gov:internal:hl7-messages <xsl:value-of select="$hl7msg:schemaLocation" /></xsl:attribute>

      <xsl:apply-templates select="$data/wns:message/*" mode="hl7typ:segments">
        <xsl:with-param name="fieldDelimiter" select="$fieldDelimiter" />
        <xsl:with-param name="componentDelimiter" select="$componentDelimiter" />
        <xsl:with-param name="subComponentDelimiter" select="$subComponentDelimiter" />
        <xsl:with-param name="repeatingFieldDelimiter" select="$repeatingFieldDelimiter" />
        <xsl:with-param name="escapeCharacter" select="$escapeCharacter" />
      </xsl:apply-templates>
    </xsl:element>
  </xsl:template>
</xsl:stylesheet>
