package gov.va.med.fw.util;

// Library classes
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import junit.framework.TestCase;


public class StringUtilsTest extends TestCase {

	/**
	 * Logger available to subclasses.
	 */
	protected final Log logger = LogFactory.getLog(getClass());
	
	public StringUtilsTest(String arg0) {
		super(arg0);
	}

	/*
	 * Test method for 'gov.va.med.fw.util.DateUtils.createCalendar(int)'
	 */
	public void testTruncToMaxLength() {

		String inputValue = "VIVA/DD214/IN SUPPORT OF OPERATION ENDURING FREEDOM";
        String result = StringUtils.truncToMaxLength(inputValue, 50);
        assertEquals(result, "VIVA/DD214/IN SUPPORT OF OPERATION ENDURING FREEDO");
        
        result = null;
        inputValue = null;
        
        inputValue = "VIVA/DD214/IN SUPPORT OF OPERATION ENDURING FREEDO";
        result = StringUtils.truncToMaxLength(inputValue, 50);
        assertEquals(result, inputValue);
        
        result = null;
        inputValue = null;
        
        inputValue = "IN SUPPORT OF OPERATION ENDURING FREEDOM";
        result = StringUtils.truncToMaxLength(inputValue, 50);
        assertEquals(result, inputValue);
        
        result = null;
        inputValue = null;
        
        inputValue = "";
        result = StringUtils.truncToMaxLength(inputValue, 50);
        assertEquals(result, inputValue);
        
        result = null;
        inputValue = null;
        
        result = StringUtils.truncToMaxLength(inputValue, 50);
        assertNull(result);
	}

}