package gov.va.med.fw.util;

// Java classes
import java.util.Calendar;
import java.text.DateFormat;

// Library classes
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import junit.framework.TestCase;

// Framework classes

// ESR classes

public class DateUtilsTest extends TestCase {

	/**
	 * Logger available to subclasses.
	 */
	protected final Log logger = LogFactory.getLog(getClass());
	
	public DateUtilsTest(String arg0) {
		super(arg0);
	}

	/*
	 * Test method for 'gov.va.med.fw.util.DateUtils.createCalendar(int)'
	 */
	public void testCreateCalendar() {

		int year = 2002;
		Calendar calendar = DateUtils.createCalendar( year );
		assertEquals( calendar.get( Calendar.YEAR ), year );

		int month = 10; // base 0
		calendar = DateUtils.createCalendar( year, month );
		assertEquals( calendar.get( Calendar.YEAR ), year );
		assertEquals( calendar.get( Calendar.MONTH ), (month - 1) );
		
		int date = 20;
		calendar = DateUtils.createCalendar( year, month, date );
		assertEquals( calendar.get( Calendar.YEAR ), year );
		assertEquals( calendar.get( Calendar.MONTH ), (month - 1) );
		assertEquals( calendar.get( Calendar.DATE ), date );
		
		int hour = 1;
		calendar = DateUtils.createCalendar( year, month, date, hour );
		assertEquals( calendar.get( Calendar.YEAR ), year );
		assertEquals( calendar.get( Calendar.MONTH ), (month - 1) );
		assertEquals( calendar.get( Calendar.DATE ), date );
		assertEquals( calendar.get( Calendar.HOUR ), hour );
		
		int min = 4;
		calendar = DateUtils.createCalendar( year, month, date, hour, min );
		assertEquals( calendar.get( Calendar.YEAR ), year );
		assertEquals( calendar.get( Calendar.MONTH ), (month - 1) );
		assertEquals( calendar.get( Calendar.DATE ), date );
		assertEquals( calendar.get( Calendar.HOUR ), hour );
		assertEquals( calendar.get( Calendar.MINUTE ), min );

		int sec = 5;
		calendar = DateUtils.createCalendar( year, month, date, hour, min, sec );
		assertEquals( calendar.get( Calendar.YEAR ), year );
		assertEquals( calendar.get( Calendar.MONTH ), (month - 1) );
		assertEquals( calendar.get( Calendar.DATE ), date );
		assertEquals( calendar.get( Calendar.HOUR ), hour );
		assertEquals( calendar.get( Calendar.MINUTE ), min );
		assertEquals( calendar.get( Calendar.SECOND ), sec );
	}
	
	public void testFiscalYearCalendar() {
		
		// Test first quarter
		logger.info( "Test first quarter");
		Calendar calendar = DateUtils.getFiscalYearFirstQuarter( 2002, true );
		Calendar expected = DateUtils.createCalendar( 2001, 10, 1 );
		
		logger.info( "Test start date");
		logger.info( "Returned: " + calendar.getTime() );
		logger.info( "Expected: " + expected.getTime() );
		assertEquals( calendar.getTime(), expected.getTime() );
		
		calendar = DateUtils.getFiscalYearFirstQuarter( 2002, false );
		expected = DateUtils.createCalendar( 2001, 12, 31 );
		
		logger.info( "Test end date");
		logger.info( "Returned: " + calendar.getTime() );
		logger.info( "Expected: " + expected.getTime() );
		assertEquals( calendar.getTime(), expected.getTime() );

		// Test second quarter
		logger.info( "Test second quarter");
		calendar = DateUtils.getFiscalYearSecondQuarter( 2002, true );
		expected = DateUtils.createCalendar( 2002, 1, 1 );
		
		logger.info( "Test start date");
		logger.info( "Returned: " + calendar.getTime() );
		logger.info( "Expected: " + expected.getTime() );
		assertEquals( calendar.getTime(), expected.getTime() );
		
		calendar = DateUtils.getFiscalYearSecondQuarter( 2002, false );
		expected = DateUtils.createCalendar( 2002, 3, 31 );
		
		logger.info( "Test end date");
		logger.info( "Returned: " + calendar.getTime() );
		logger.info( "Expected: " + expected.getTime() );
		assertEquals( calendar.getTime(), expected.getTime() );
		
		// Test third quarter
		logger.info( "Test third quarter");
		calendar = DateUtils.getFiscalYearThirdQuarter( 2002, true );
		expected = DateUtils.createCalendar( 2002, 4, 1 );
		
		logger.info( "Test start date");
		logger.info( "Returned: " + calendar.getTime() );
		logger.info( "Expected: " + expected.getTime() );
		assertEquals( calendar.getTime(), expected.getTime() );
		
		calendar = DateUtils.getFiscalYearThirdQuarter( 2002, false );
		expected = DateUtils.createCalendar( 2002, 6, 30 );
		
		logger.info( "Test end date");
		logger.info( "Returned: " + calendar.getTime() );
		logger.info( "Expected: " + expected.getTime() );
		assertEquals( calendar.getTime(), expected.getTime() );
		
		// test fourth quarter
		logger.info( "Test fourth quarter");
		calendar = DateUtils.getFiscalYearFourthQuarter( 2002, true );
		expected = DateUtils.createCalendar( 2002, 7, 1 );
		
		logger.info( "Test start date");
		logger.info( "Returned: " + calendar.getTime() );
		logger.info( "Expected: " + expected.getTime() );
		assertEquals( calendar.getTime(), expected.getTime() );
		
		calendar = DateUtils.getFiscalYearFourthQuarter( 2002, false );
		expected = DateUtils.createCalendar( 2002, 9, 30 );
		
		logger.info( "Test end date");
		logger.info( "Returned: " + calendar.getTime() );
		logger.info( "Expected: " + expected.getTime() );
		assertEquals( calendar.getTime(), expected.getTime() );
	}
	
	public void testFiscalYearQuarter() {
		logger.info( "Test first quarter");
		Calendar calendar = DateUtils.getFiscalYearQuarter( 2002, true, DateUtils.FIRST_QUARTER.getCode() );
		Calendar expected = DateUtils.createCalendar( 2001, 10, 1 );
		
		DateFormat df = DateFormat.getDateInstance( DateFormat.MEDIUM );
		
		logger.info( "Test start date");
		logger.info( "Returned: " + df.format( calendar.getTime() ) );
		logger.info( "Expected: " + df.format( expected.getTime() ) );
		assertEquals( calendar.getTime(), expected.getTime() );

		expected = DateUtils.createCalendar( 2001, 10, 30 );
		logger.info( "Input: " + df.format( expected.getTime() ) );
		logger.info( "Fiscal year " + DateUtils.getFiscalYear( expected.getTime() ) );
		logger.info( DateUtils.getQuarterAsString( expected.getTime() ) );
	}
}