package gov.va.med.fw.service.config;

// Java classes
import java.util.List;
import java.util.Map;

// Library classes
import org.apache.commons.lang.ClassUtils;

// Framework classes
import gov.va.med.fw.util.AbstractContextAwareTestCase;

// ESR classes

public class InheritedCollectionFactoryBeanTest extends AbstractContextAwareTestCase {

	public InheritedCollectionFactoryBeanTest() {
		super();
	}
	
	public void testInheritedAbstractListFactoryBean() {

		logger.info("testInheritedAbstractListFactoryBean");
		Object bean = this.applicationContext.getBean( "NoInheritedAbstractList" );
		assertTrue( bean instanceof List );
		int childListSize =  ((List)bean).size(); // Should be 3 because there is no inheritance
		assertTrue( childListSize == 3 );
		logger.info( "A child List with no inheritance" );
		logger.info( bean );
		
		bean = this.applicationContext.getBean( "InheritedAbstractList" );
		assertTrue( bean instanceof List );
		childListSize =  ((List)bean).size(); // Should be 6 because it is a combination of both
		assertTrue( childListSize == 6 );
		logger.info( "A child List with inheritance" );
		logger.info( bean );
	}
	
	public void testInheritedListFactoryBean() {

		logger.info("testInheritedListFactoryBean");
		Object bean = this.applicationContext.getBean( ClassUtils.getShortClassName( InheritedListFactoryBean.class ) );
		assertTrue( bean instanceof List );
		int beanListSize =  ((List)bean).size(); // Should be 3 
		assertTrue( beanListSize == 3 );
		
		bean = this.applicationContext.getBean( "NoInheritedList" );
		assertTrue( bean instanceof List );
		beanListSize =  ((List)bean).size(); // Should be 3 because there is no inheritance
		assertTrue( beanListSize == 3 );
		logger.info( "A child List with no inheritance" );
		logger.info( bean );
		
		bean = this.applicationContext.getBean( "InheritedList" );
		assertTrue( bean instanceof List );
		beanListSize =  ((List)bean).size(); // Should be 6 because it is a combination of both
		assertTrue( beanListSize == 6 );
		logger.info( "A child List with inheritance" );
		logger.info( bean );
	}
	
	public void testInheritedMapFactoryBean() {

		logger.info("testInheritedMapFactoryBean");
		Object bean = this.applicationContext.getBean( ClassUtils.getShortClassName( InheritedMapFactoryBean.class ) );
		assertTrue( bean instanceof Map );
		int beanListSize =  ((Map)bean).size(); // Should be 3 
		assertTrue( beanListSize == 3 );
		
		bean = this.applicationContext.getBean( "NoInheritedMap" );
		assertTrue( bean instanceof Map );
		beanListSize =  ((Map)bean).size(); // Should be 3 because there is no inheritance
		assertTrue( beanListSize == 3 );
		logger.info( "A child Map with no inheritance" );
		logger.info( bean );
		
		bean = this.applicationContext.getBean( "InheritedMap" );
		assertTrue( bean instanceof Map );
		beanListSize =  ((Map)bean).size(); // Should be 6 because it is a combination of both
		assertTrue( beanListSize == 6 );
		logger.info( "A child Map with inheritance" );
		logger.info( bean );
	}

	public void testInheritedAbstractMapFactoryBean() {

		logger.info("testInheritedAbstractMapFactoryBean");
		Object bean = this.applicationContext.getBean( "NoInheritedAbstractMap" );
		assertTrue( bean instanceof Map );
		int childListSize =  ((Map)bean).size(); // Should be 3 because there is no inheritance
		assertTrue( childListSize == 3 );
		logger.info( "A child Map with no inheritance" );
		logger.info( bean );
		
		bean = this.applicationContext.getBean( "InheritedAbstractMap" );
		assertTrue( bean instanceof Map );
		childListSize =  ((Map)bean).size(); // Should be 6 because it is a combination of both
		assertTrue( childListSize == 6 );
		logger.info( "A child Map with inheritance" );
		logger.info( bean );
	}
}
