/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.service;

import java.util.Iterator;

import gov.va.med.fw.model.BOMChild;
import gov.va.med.fw.model.BOMCousin;
import gov.va.med.fw.model.BOMDescendant;
import gov.va.med.fw.model.BOMParent;
import gov.va.med.fw.model.ConfigurableModelProperties;
import gov.va.med.fw.model.lookup.ModelPropertiesApplicationType;
import gov.va.med.fw.util.AbstractTestCase;
import gov.va.med.fw.util.ModelPropertiesManager;

/**
 * Initial javadoc for class TestModelPropertiesService.
 * TODO - Add content here
 * 
 * Created Sep 11, 2006 10:17:20 AM
 * @author DNS   BOHMEG
 */
public class TestModelPropertiesService extends AbstractTestCase {
	private ModelPropertiesManager modelPropertiesService;
	
	protected boolean shouldTestCaseStartTransaction() {
		return false;
	}
	
	public void testGetModelProperties() {
		Class clazz = BOMParent.class;
		displayWellKnownModelProperties(clazz);
		displayModelProperties(clazz, "customX");

		clazz = BOMChild.class;
		displayWellKnownModelProperties(clazz);
		displayModelProperties(clazz, "customX");

		clazz = BOMCousin.class;
		displayWellKnownModelProperties(clazz);
		displayModelProperties(clazz, "customX");
		
		clazz = BOMDescendant.class;
		displayWellKnownModelProperties(clazz);
		displayModelProperties(clazz, "customX");		
	}

	private void displayWellKnownModelProperties(Class clazz) {
		displayModelProperties(clazz, ModelPropertiesApplicationType.IDENTITY.getName(),
				getModelProperties(clazz, ModelPropertiesApplicationType.IDENTITY.getName()));		
		displayModelProperties(clazz, ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName(),
				getModelProperties(clazz, ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName()));
		displayModelProperties(clazz, ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName(), 
				getModelProperties(clazz, ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName()));
	}
	
	private void displayModelProperties(Class clazz, String application) {
		displayModelProperties(clazz, application, getModelProperties(clazz, application));
	}
	
	private void displayModelProperties(Class clazz, String application, ConfigurableModelProperties modelProperties) {
		System.out.println("**** " + clazz.getName() + " [application: " + application + "]");
		System.out.println("\t inclusions: " + modelProperties.getInclusions());
		System.out.println("\t exclusions: " + modelProperties.getExclusions());
		if(modelProperties.getGlobalProperties() != null) {
			System.out.println("\t\t (global) inclusions: " + modelProperties.getGlobalProperties().getInclusions());
			System.out.println("\t\t (global) exclusions: " + modelProperties.getGlobalProperties().getExclusions());
		}
		System.out.println("Fields used: " + modelPropertiesService.getModelProperties(clazz, application));
	}
	
	private ConfigurableModelProperties getModelProperties(Class clazz, String application) {
		return modelPropertiesService.getConfigurableModelProperties(clazz, application);
	}
	
	private BOMParent fullGraph() {
		BOMParent parent1 = new BOMParent();
		parent1.setParentCustomX("1");
		parent1.setParentMatchDomainConcept("2");
		parent1.setParentMatchDomainValues("3");
			
		BOMChild child1 = new BOMChild();
		child1.setChildCustomX("1.0");
		child1.setChildMatchDomainConcept("2.0");
		child1.setChildMatchDomainValues("3.0");
		parent1.addChild(child1);
		BOMChild child2 = new BOMChild();
		child2.setChildCustomX("1.1");
		child2.setChildMatchDomainConcept("2.1");
		child2.setChildMatchDomainValues("3.1");
		parent1.addChild(child2);
				
		BOMCousin cousin = new BOMCousin();
		cousin.setCousinCustomX("1");
		cousin.setCousinMatchDomainConcept("2");
		cousin.setCousinMatchDomainValues("3");
		parent1.setCousin(cousin);
		
		return parent1;
	}
	
	public void testIdentity() {
		BOMParent parent1 = fullGraph();
		BOMParent parent2 = fullGraph();
		assertTrue(parent1.equals(parent2));
		
		parent2.getCousin().setCousinCustomX("fsdfsd");
		assertTrue(!parent1.equals(parent2));
	}
	
	public void testMatchesDomainConcept1() {
		BOMParent parent1 = fullGraph();
		BOMParent parent2 = fullGraph();
		parent1.setParentMatchDomainValues("fdsfsdddsdsfsdfdsf");
		assertTrue(parent1.matchesDomainConcept(parent2));
		
		parent1.getCousin().setCousinCustomX("fdsfsdf");
		Iterator itr = parent2.getChildren().iterator();
		while(itr.hasNext()) {
			((BOMChild) itr.next()).setChildMatchDomainValues("fdsfggggg");
		}
		assertTrue(parent1.matchesDomainConcept(parent2));		
		parent2.getCousin().setCousinMatchDomainConcept("ttt");
		assertTrue(!parent1.getCousin().matchesDomainConcept(parent2.getCousin()));
	}

	public void testMatchesDomainConcept2() {
		BOMParent parent1 = fullGraph();
		BOMParent parent2 = fullGraph();
		
		parent2.getCousin().setType("4389579234rtff");
		assertTrue(!parent1.getCousin().matchesDomainConcept(parent2.getCousin()));
	}
	
	public void testMatchesDomainValues() {
		BOMParent parent1 = fullGraph();
		BOMParent parent2 = fullGraph();
		parent1.setParentMatchDomainConcept("fdsfsdddsdsfsdfdsf");
		assertTrue(parent1.matchesDomainValues(parent2));
		
		parent1.getCousin().setCousinCustomX("fdsfsdf");
		Iterator itr = parent2.getChildren().iterator();
		while(itr.hasNext()) {
			((BOMChild) itr.next()).setChildMatchDomainConcept("fdsfggggg");
		}
		assertTrue(parent1.matchesDomainValues(parent2));
		parent2.getCousin().setCousinMatchDomainValues("ttt");
		assertTrue(!parent1.getCousin().matchesDomainValues(parent2.getCousin()));
	}
	
	public void testMatchesCustomX() {
		BOMParent parent1 = fullGraph();
		BOMParent parent2 = fullGraph();
		parent1.setParentMatchDomainValues("fdsfsdddsdsfsdfdsf");
		assertTrue(parent1.isModelPropertiesEqual(parent2, "customX"));
		
		Iterator itr = parent2.getChildren().iterator();
		while(itr.hasNext()) {
			((BOMChild) itr.next()).setChildMatchDomainValues("fdsfggggg");
		}
		assertTrue(parent1.isModelPropertiesEqual(parent2, "customX"));
		parent2.getCousin().setCousinCustomX("ttt");
		assertTrue(!parent1.getCousin().isModelPropertiesEqual(parent2.getCousin(), "customX"));
		assertTrue(!parent1.isModelPropertiesEqual(parent2, "customX"));
	}
	
	/**
	 * @return Returns the modelPropertiesService.
	 */
	public ModelPropertiesManager getModelPropertiesService() {
		return modelPropertiesService;
	}

	/**
	 * @param modelPropertiesService The modelPropertiesService to set.
	 */
	public void setModelPropertiesService(
			ModelPropertiesManager modelPropertiesService) {
		this.modelPropertiesService = modelPropertiesService;
	}	
}
