/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report.data;

// Java classes
import java.util.List;

// Library classes

// Framework classes
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.report.data.ReportDataService;
import gov.va.med.fw.report.jasperreport.data.JasperReportData;
import gov.va.med.fw.service.AbstractComponent;

// ESR classes

/**
 * 
 *
 * Project: Framework</br>
 * Created on: 2:22:48 PM </br>
 *
 * @author DNS   LEV
 */
public class JasperReportDataService extends AbstractComponent implements ReportDataService {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 9214006280523467818L;

	private List reportData = null;
	
	/**
	 * A default constructor
	 */
	public JasperReportDataService() {
		super();
	}

	/**
	 * @see gov.va.med.fw.report.data.ReportDataService#requestReportData(gov.va.med.fw.report.ReportConfiguration)
	 */
	public ReportData requestReportData( ReportConfiguration configuration ) throws ReportException {
		return new JasperReportData( this.reportData );
	}

	/**
	 * @param reportData The reportData to set.
	 */
	public void setReportData(List reportData) {
		this.reportData = reportData;
	}
}