package gov.va.med.fw.report;

// Java classes
import java.io.File;

// Library classes

// Framework classes
import gov.va.med.fw.util.AbstractContextAwareTestCase;

/**
 * Provides test cases for different methods of a ReportService
 * This test is injected with a synchronous report service 
 *
 * Project: Framework</br>
 * Created on: 3:01:25 PM </br>
 *
 * @author DNS   LEV
 */
public class ReportExporterTest extends AbstractContextAwareTestCase {

	private static final String TEST_REPORT_PATH = "." + File.separator + "jasper-reports" + File.separator;
	
	/**
	 * An instance of reportService
	 */
	private ReportService reportService = null;
	
	/**
	 * A default constructor
	 */
	public ReportExporterTest() {
		super();
	}
	
	/**
	 * @return Returns the reportService.
	 */
	public ReportService getReportService() {
		return reportService;
	}

	/**
	 * @param reportService The reportService to set.
	 */
	public void setReportService(ReportService reportService) {
		this.reportService = reportService;
	}
	
	public void testPDFEmptyReport() throws Exception {
		
		// Get a report service
		ReportService service = this.getReportService();
		
		// Build a report configuration
		String output = TEST_REPORT_PATH + "report.pdf";
		ReportConfiguration config = new ReportConfiguration("pdfReport", "2", ReportExportedType.PDF, output );

		service.generateReport( config );
	}
	
	public void testXLSEmptyReport() throws Exception {
		
		// Get a report service
		ReportService service = this.getReportService();
		
		// Build a report configuration
		String output = TEST_REPORT_PATH + "report.xls";
		ReportConfiguration config = new ReportConfiguration("xlsReport", "3", ReportExportedType.XLS, output );

		service.generateReport( config );
	}
	public void testRTFEmptyReport() throws Exception {
		
		// Get a report service
		ReportService service = this.getReportService();
		
		// Build a report configuration
		String output = TEST_REPORT_PATH + "report.rtf";
		ReportConfiguration config = new ReportConfiguration("rtfReport", "4", ReportExportedType.RTF, output );

		service.generateReport( config );
	}
	public void testCSVEmptyReport() throws Exception {
		
		// Get a report service
		ReportService service = this.getReportService();
		
		// Build a report configuration
		String output = TEST_REPORT_PATH + "report.csv";
		ReportConfiguration config = new ReportConfiguration("csvReport", "5", ReportExportedType.CSV, output );

		service.generateReport( config );
	}
	public void testHTMLEmptyReport() throws Exception {
		
		// Get a report service
		ReportService service = this.getReportService();
		
		// Build a report configuration
		String output = TEST_REPORT_PATH + "report.html";
		ReportConfiguration config = new ReportConfiguration("htmlReport", "6", ReportExportedType.HTML, output );

		service.generateReport( config );
	}
}