/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.model;

import java.util.HashSet;
import java.util.Set;

/**
 * Initial javadoc for class BOMParent.
 * TODO - Add content here
 * 
 * Created Sep 8, 2006 3:49:37 PM
 * @author DNS   BOHMEG
 */
public class BOMParent extends AbstractKeyedEntity {

    private static final long serialVersionUID = -1941180191719558937L;
    private BOMCousin cousin;
	private Set children = new HashSet();
	private String parentMatchDomainConcept;
	private String parentMatchDomainValues;
	private String parentCustomX;

    /**
     * @return Returns the children.
     */
    public Set getChildren() {
        return children;
    }
	/**
	 * @param children The children to set.
	 */
	public void setChildren(Set children) {
		this.children = children;
	}
	public void addChild(BOMChild child) {
		child.setParent(this);
		children.add(child);
	}
	/**
	 * @return Returns the cousin.
	 */
	public BOMCousin getCousin() {
		return cousin;
	}
	/**
	 * @param cousin The cousin to set.
	 */
	public void setCousin(BOMCousin cousin) {
		this.cousin = cousin;
		cousin.setParent(this);
	}
	/**
	 * @return Returns the parentCustomX.
	 */
	public String getParentCustomX() {
		return parentCustomX;
	}
	/**
	 * @param parentCustomX The parentCustomX to set.
	 */
	public void setParentCustomX(String parentCustomX) {
		this.parentCustomX = parentCustomX;
	}
	/**
	 * @return Returns the parentMatchDomainConcept.
	 */
	public String getParentMatchDomainConcept() {
		return parentMatchDomainConcept;
	}
	/**
	 * @param parentMatchDomainConcept The parentMatchDomainConcept to set.
	 */
	public void setParentMatchDomainConcept(String parentMatchDomainConcept) {
		this.parentMatchDomainConcept = parentMatchDomainConcept;
	}
	/**
	 * @return Returns the parentMatchDomainValues.
	 */
	public String getParentMatchDomainValues() {
		return parentMatchDomainValues;
	}
	/**
	 * @param parentMatchDomainValues The parentMatchDomainValues to set.
	 */
	public void setParentMatchDomainValues(String parentMatchDomainValues) {
		this.parentMatchDomainValues = parentMatchDomainValues;
	}
}
