package gov.va.med.fw.mail;

// Java classes

// Library classes
import org.springframework.mail.SimpleMailMessage;
import org.springframework.core.io.Resource;

// Framework classes
import gov.va.med.fw.util.AbstractContextAwareTestCase;

/**
 * Provides test cases to test different methods in MailService class 
 *
 * Project: Framework</br>
 * Created on: 2:32:08 PM </br>
 *
 * @author DNS   LEV
 */
public class MailServiceTest extends AbstractContextAwareTestCase {

	/**
	 * An instance of mailService
	 */
	private MailService mailService = null;
	
	/**
	 * An instance of messageTemplate
	 */
	private SimpleMailMessage messageTemplate = null;
	
	/**
	 * An instance of messageAttachment
	 */
	private Resource messageAttachment = null;
	
	/**
	 * A default constructor
	 */
	public MailServiceTest() {
		super();
	}
	
	/**
	 * @return Returns the mailService.
	 */
	public MailService getMailService() {
		return mailService;
	}

	/**
	 * @param mailService The mailService to set.
	 */
	public void setMailService(MailService mailService) {
		this.mailService = mailService;
	}

	/**
	 * @return Returns the messageTemplate.
	 */
	public SimpleMailMessage getMessageTemplate() {
		return messageTemplate;
	}

	/**
	 * @param messageTemplate The messageTemplate to set.
	 */
	public void setMessageTemplate(SimpleMailMessage messageTemplate) {
		this.messageTemplate = messageTemplate;
	}

	/**
	 * @return Returns the messageAttachment.
	 */
	public Resource getMessageAttachment() {
		return messageAttachment;
	}

	/**
	 * @param messageAttachment The messageAttachment to set.
	 */
	public void setMessageAttachment(Resource messageAttachment) {
		this.messageAttachment = messageAttachment;
	}

	/** Tests a send method in MailService to send a simple text message
	 * @throws Exception In case of errors in test
	 */
	public void testTextMessage() throws Exception {
		
		// Get a mail service
		MailService service = this.getMailService();
		
		// Get a message template
		SimpleMailMessage template = this.getMessageTemplate();
	
		// Send a message
		service.send( "This is a simple test message", template );
	}
	
	/** Tests a send method in MailService to send a simple text message and an attachment
	 * @throws Exception In case of errors in test
	 */
	public void testTextMessageWithAttachment() throws Exception {
		
		// Get a mail service
		MailService service = this.getMailService();
		
		// Get a message template
		SimpleMailMessage template = this.getMessageTemplate();
	
		// Send a message
		service.send( "This is a simple test message", "SampleReport.pdf", template );
	}
	
	/** Tests a send method in MailService to send a simple text message
	 * and a generic message resource as an attachment
	 * @throws Exception In case of errors in test
	 */
	public void testTextMessageWithResource() throws Exception {
		
		// Get a mail service
		MailService service = this.getMailService();
		
		// Get a message template
		SimpleMailMessage template = this.getMessageTemplate();
	
		// Get a message attachment
		Resource attachment = this.getMessageAttachment();
	
		// Send a message
		service.send( "This is a simple test message", attachment, template );
	}
}