/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.ArrayList;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.constants.DelimeterConstants;
import gov.va.med.fw.hl7.segment.BHS;
import gov.va.med.fw.hl7.segment.MSA;
import gov.va.med.fw.util.AbstractContextAwareTestCase;

/**
 * @author DNS   LEV
 * @version 1.0
 */
public class SegmentTest extends AbstractContextAwareTestCase {

   public SegmentTest( String name ) {
      super( name );
   }
   
   public void testBHS() throws InvalidSegmentException {
      /*
       * BHS^~|\&^MVR^AAC^EDBeGate^200^200410011503^^~T~ORF|Z11~2.3.1~AL~AL^^5806006
       */
      // A list of elements
      ArrayList list = new ArrayList();
      list.add( DelimeterConstants.DEFAULT_FIELD_DELIMITER );
      list.add( DelimeterConstants.DEFAULT_ENCODING_ELEMENT );
      list.add( "MVR");
      list.add( "AAC");
      list.add( "EDBeGate" );
      list.add( "200" );
      list.add( "200410011503" );
      list.add( null );
      list.add( "~T~ORF|Z11~2.3.1~AL~AL" );
      list.add( null );
      list.add( "5806006" );
      
      // A raw string data
      StringBuffer data = new StringBuffer("BHS");
      data.append( DelimeterConstants.DEFAULT_FIELD_DELIMITER )
          .append( DelimeterConstants.DEFAULT_ENCODING_ELEMENT )
      	  .append( "^MVR^AAC^EDBeGate^200^200410011503^^~T~ORF|Z11~2.3.1~AL~AL^^5806006" );

      // Test construtor 1
      BHS segment = new BHS( "BHS", list );
      assertNotNull( "Constructor 1: " + segment.getElementData() );
      
      // Test construtor 2
      segment = new BHS( DelimeterConstants.DEFAULT_ENCODERS, DelimeterConstants.DEFAULT_FIELD_DELIMITER, "BHS", list );
      assertNotNull( "Constructor 2: " + segment.getElementData() );

      // Test construtor 3
      segment = new BHS( data.toString() );
      assertNotNull( "Constructor 3: " + segment.getElementData() );
      
      // Test construtor 4
      segment = new BHS( DelimeterConstants.DEFAULT_ENCODERS, DelimeterConstants.DEFAULT_FIELD_DELIMITER, data.toString() );
      assertNotNull( "Constructor 4: " + segment.getElementData() );
      
      // Test construtor 5
      segment = new BHS();
      segment.setFieldSeparator( DelimeterConstants.DEFAULT_FIELD_DELIMITER );
      segment.setEncodingCharacters( DelimeterConstants.DEFAULT_ENCODING_ELEMENT);
      segment.setSendingApplication( "MVR" );
      segment.setSendingFacility( "AAC" );
      segment.setReceivingApplication( "EDBeGate" );
      segment.setReceivingFacility( "200" );
      segment.setCreationDate( "200410011503" );
      segment.setNameIDType( "~T~ORF|Z11~2.3.1~AL~AL" );
      segment.setControlID( "5806006" );
      assertNotNull( "Constructor 5: " + segment.getElementData() );
      
      // test modification of a BHS segment
      String currentData = segment.getElementData();
      segment.setReceivingFacility( "400" );
      String newData = segment.getElementData();
      assertNotSame( "Segment data was modified ", currentData, newData );
   }
   
   public void testMSA() throws InvalidSegmentException {
       /*
        * 
        * MSA^AA^123456789^
        */
       // A list of elements
       
       ArrayList list = new ArrayList();
       list.add( "AA");
       list.add( "123456789");
       list.add( null );
       
       // A raw string data
       StringBuffer data = new StringBuffer("MSA");
       data.append( "^AA^123456789^" );

       // Test construtor 1
       MSA segment = new MSA( "MSA", list );
       assertNotNull( "Constructor 1: " + segment.getElementData() );
       
       // Test construtor 2
       segment = new MSA( DelimeterConstants.DEFAULT_ENCODERS, DelimeterConstants.DEFAULT_FIELD_DELIMITER, "MSA", list );
       assertNotNull( "Constructor 2: " + segment.getElementData() );

       // Test construtor 3
       segment = new MSA( data.toString() );
       assertNotNull( "Constructor 3: " + segment.getElementData() );
       
       // Test construtor 4
       segment = new MSA( DelimeterConstants.DEFAULT_ENCODERS, DelimeterConstants.DEFAULT_FIELD_DELIMITER, data.toString() );
       assertNotNull( "Constructor 4: " + segment.getElementData() );
        
       // Test construtor 5
       segment = new MSA();
       segment.setAcknowledgementCode("AA");
       segment.setMessageControlID("123456789");
       segment.setTextMessage(null);
       assertNotNull( "Constructor 5: " + segment.getElementData() );

       // test modification of a BHS segment
       String currentData = segment.getElementData();
       segment.setMessageControlID( "111111111" );
       String newData = segment.getElementData();
       assertNotSame( "Segment data was modified ", currentData, newData );
   }
}
