/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.fw.hl7.segment;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;

import gov.va.med.fw.hl7.BatchMessage;
import gov.va.med.fw.util.AbstractContextAwareTestCase;

/**
 * @author DNS   LEV
 * @version 1.0
 */
public class MessageTest extends AbstractContextAwareTestCase {
	/**
	 * An instance of ORUZ11_FILE
	 */
	protected static final String ORUZ11_FILE = "ORUZ11.txt";

	/**
	 * A default constructor
	 * @param name
	 */
	public MessageTest(String name) {
		super(name);
	}

	/**
	 * 
	 */
	public void testMessageReader() {
		try {
			BatchMessage inbound = 
				new BatchMessage(	createTestMessageFromFile(ORUZ11_FILE) );
			List list = inbound.getSegments();
			assertNotNull(list);
		}
		catch (Exception e) {
			fail("Can not create Message", e);
		}
	}

	/**
	 * @param fileName
	 * @return
	 * @throws Exception
	 */
	protected String createTestMessageFromFile(String fileName) throws Exception {
		StringBuffer content = new StringBuffer();
		InputStreamReader input = new InputStreamReader(new BufferedInputStream(
				ClassLoader.getSystemResourceAsStream(fileName)));
		BufferedReader in = new BufferedReader(input);
		String data = null;
		while ((data = in.readLine()) != null) {
			content.append(data).append("\n");
		}
		in.close();
		String msg = content.toString();
		logger.info(msg);
		return msg;
	}
}