/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.batchprocess;

import gov.va.med.fw.scheduling.AbstractScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;

/**
 * Initial javadoc for class MockDataProcessWithDelay.
 * TODO - Add content here
 * 
 * Created Apr 28, 2006 2:51:09 PM
 * @author DNS   BOHMEG
 */
public class MockDataProcessWithDelay extends AbstractScheduledProcess {
	private Integer delayTime;

	/* (non-Javadoc)
	 * @see gov.va.med.fw.scheduling.AbstractScheduledProcess#executeProcess(java.lang.Object)
	 */
	protected void executeProcess(ScheduledProcessInvocationContext context) throws Exception {
		Thread.sleep(delayTime.intValue() * 1000);
		System.out.println(getAuditInfo() + delayTime + " completed!");
	}

	/**
	 * @return Returns the delayTime.
	 */
	public Integer getDelayTime() {
		return delayTime;
	}

	/**
	 * @param delayTime The delayTime to set.
	 */
	public void setDelayTime(Integer delayTime) {
		this.delayTime = delayTime;
	}
}
