/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.validation;

// Framework classes
import gov.va.med.fw.service.ServiceException;

/**
 * This exception is thrown when there is an error in the validation service.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class ValidationServiceException extends ServiceException {
	
	/**
	 * An instance of validationMessages
	 */
	private ValidationMessages validationMessages = null;
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -3377064026752636609L;

	/**
	 * An exception with the specific message
	 * @param message
	 */
	public ValidationServiceException( String message) {
		super(message);
	}

	/**
	 * An exception with the specific message and its exception cause 
	 * @param message
	 * @param previousException
	 */
	public ValidationServiceException( String message, Exception previousException ) {
		super( message, previousException );
	}
	
	/**
	 * An exception with the specific message and a validation message 
	 * containing all validation messages.
	 * 
	 * @param validationMessages A collection of validation messages
	 */
	public ValidationServiceException( ValidationMessages validationMessages ) {
		this.validationMessages = validationMessages;
	}

	public ValidationServiceException( String message, ValidationMessages validationMessages ) {
		super(message);
		this.validationMessages = validationMessages;
	}
	
	public ValidationMessages getValidationMessages() {
		return validationMessages;
	}

	public String getMessage() {
		if(this.validationMessages != null)
			return this.validationMessages.getAllMessageText();
		else
			return super.getMessage();
	}
}