package gov.va.med.fw.validation;

import gov.va.med.fw.model.lookup.SeverityType;

/**
 * This class is a representation of a validation message for a named field.
 *
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class ValidationFieldMessage extends ValidationMessage
{	
	private SeverityType severity = SeverityType.ERROR; 
	
	// CCR10399 -- added attribute to allow the option of not generating worklist
	// item when a consistency check fails
	private boolean createWkList = true;

	
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1567241374520369212L;
	//The name of the this message is associated.
	protected String fieldName;

    /**
     * Construct an action message with no replacement values.
     *
     * @param fieldName Name of the field
     * @param key Message key for this message
     * @param severity Severity of the validation message
     */
	public ValidationFieldMessage(String fieldName,String key, SeverityType severity) 
	{
		super(key);
		this.fieldName = fieldName;
		this.severity = severity;
	}
	
    /**
     * Construct an action message with no replacement values.
     *
     * @param fieldName Name of the field
     * @param key Message key for this message
     */
	public ValidationFieldMessage(String fieldName,String key) 
	{
		super(key);
		this.fieldName = fieldName;
	}
	
    /**
     * Construct an action message with the specified replacement values.
     *
     * @param fieldName Name of the field
     * @param key Message key for this message
     * @param value0 First replacement value
     */
	public ValidationFieldMessage(String fieldName,String key,Object value0) 
	{
		super(key,value0);
		this.fieldName = fieldName;
	}
	
    /**
     * Construct an action message with the specified replacement values.
     *
     * @param fieldName Name of the field
     * @param key Message key for this message
     * @param value0 First replacement value
     * @param value1 Second replacement value
     */
	public ValidationFieldMessage(String fieldName,String key,Object value0,Object value1) 
	{
		super(key,value0, value1);
		this.fieldName = fieldName;
	}
	
    /**
     * Construct an action message with the specified replacement values.
     *
     * @param fieldName Name of the field
     * @param key Message key for this message
     * @param value0 First replacement value
     * @param value1 Second replacement value
     * @param value2 Third replacement value
     */
	public ValidationFieldMessage(String fieldName,String key,Object value0,Object value1,Object value2) 
	{
		super(key,value0, value1, value2);
		this.fieldName = fieldName;
	}
	
    /**
     * Construct an action message with the specified replacement values.
     *
     * @param fieldName Name of the field
     * @param key Message key for this message
     * @param value0 First replacement value
     * @param value1 Second replacement value
     * @param value2 Third replacement value
     * @param value3 Fourth replacement value
     */
	public ValidationFieldMessage(String fieldName,String key,Object value0,Object value1,Object value2,Object value3) 
	{
		super(key,value0, value1, value2, value3);
		this.fieldName = fieldName;
	}
	
    /**
     * Construct an action message with the specified replacement values.
     *
     * @param fieldName Name of the field
     * @param key Message key for this message
     * @param values Array of replacement values
     */
	public ValidationFieldMessage(String fieldName,String key, Object[] values) 
	{
		super(key,values);
		this.fieldName = fieldName;
	}
	
    /**
     * Get the message key for this message.
     */
    public String getFieldName() 
    {
        return (this.fieldName);
    }
    
    /**
     * Returns a String in the format: fieldName:key[value1, value2, etc].
     */
	public String toString() 
	{
		StringBuffer buff = new StringBuffer();
		buff.append("fieldName = ");
		buff.append(this.fieldName);
		buff.append(":message key = ");
		buff.append(this.key);
		buff.append("[");

		if (this.values != null) 
		{
			for (int i = 0; i < this.values.length; i++) 
			{
				buff.append(this.values[i]);
                // don't append comma to last entry
				if (i < this.values.length - 1) 
				{
					buff.append(", ");
				}
			}
		}
		buff.append("]");
		return buff.toString();
	}

	/**
	 * @return Returns the severity.
	 */
	public SeverityType getSeverity() {
		return severity;
	}

	/**
	 * @param severity The severity to set.
	 */
	public void setSeverity(SeverityType severity) {
		this.severity = severity;
	}
	
	/**
	 * 
	 * @return createWkList
	 */
	public boolean isCreateWkList() {
		return createWkList;
	}

	/**
	 * 
	 * @param createWkList
	 */
	public void setCreateWkList(boolean createWkList) {
		this.createWkList = createWkList;
	}
}
