package gov.va.med.fw.validation;

/**
 * The input data object for validation service hould implement this interface.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public interface Validatable
{
	public static final String EXHAUSTIVE 			= "EXHAUSTIVE";
	public static final String ELIMINATION 			= "ELIMINATION";
	
	/**
	 * Gets the validation mode. If this method returns "EXHAUSTIVE" then the validation service
	 * validates all the rules in the flow(in case of rules based validation) or if the method returns 
	 * "ELIMINATION" then the validation service validates till it finds the first violation.
	 * 
	 * @return
	 */
	public String getValidationMode();
}
