/*
 * Created on Apr 25, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.fw.validation;

// Java classes
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Library
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;

/**
 * An interface to be implemented by actions to perform validation in the
 * action.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public interface ActionValidation {
	/**
	 * Performs business validation. This method will be called after
	 * validateForm() method in the action form is called. This method will be
	 * called only when there are no custom validation errors. Also, this method
	 * is called if the validation is enabled in the action mapping. The
	 * subclasses of this class needs to override this method and perform rules
	 * based or other business related validation.
	 * 
	 * @param request
	 *            The servlet request we are processing
	 * @param response
	 *            The servlet response we are creating
	 * @param form
	 *            The ActionForm instance we are populating
	 * @param mapping
	 *            The ActionMapping we are using
	 * 
	 * @return The business validation messages
	 * 
	 * @exception Exception
	 *                if any error occurs
	 */
	public ActionMessages validateAction(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception;

	/**
	 * After standard declarative validation is performed and one or more errors
	 * found, Struts will automatically forward the request onward. Some actions
	 * many need to populate reference data (like available dropdown menu items)
	 * in order for the page to display correctly. This callback method should
	 * be used to populate this reference data. It is called after errors have
	 * been created for any reason, either via declarative, form-based or
	 * action-based validation. * @param request The servlet request we are
	 * processing
	 * 
	 * @param response
	 *            The servlet response we are creating
	 * @param form
	 *            The ActionForm instance we are populating
	 * @param mapping
	 *            The ActionMapping we are using
	 */
	void failedValidationCallback(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response);
}
