/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.fw.util.builder.decorator;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class ChainedBuilder implements Builder {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8639522744754603580L;

	private Builder[] builders;

	public static Builder decorate(Builder[] builders) {
		return new ChainedBuilder(builders);
	}

	private ChainedBuilder(Builder[] builders) {
		super();

		this.builders = builders;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.util.builder.Builder#build(java.lang.Object)
	 */
	public Object build(Object input) throws BuilderException {
		Object results = input;
		for (int index = 0; index < this.builders.length; index++) {
			results = this.builders[index].build(results);
		}
		return results;
	}
}