/********************************************************************
 Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util.builder;

/**
 * An exception that is thrown if a Validator Factory fails to create a
 * validator class that implements a Validator interface.
 * 
 * @author Vu Le
 * @version 1.0
 * @since 1.0
 */
public class ValidatorException extends Exception {

   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -3236708534472944105L;
	/**
    * An instance of additional exception data
    */
   private Object data = null;

   /**
    * An empty exception
    */
   public ValidatorException() {
      super();
   }

   /**
    * An exception with a specific message
    * 
    * @param msg
    *           An exception message
    */
   public ValidatorException(String msg) {
      super(msg);
   }

   /**
    * An exception with a specific parent exception
    * 
    * @param e
    *           A parent exception in a chain
    */
   public ValidatorException(Throwable e) {
      super(e);
   }

   /**
    * An exception with a specific parent exception and a message
    * 
    * @param e
    *           A parent exception in a chain
    * @param msg
    *           An exception message
    */
   public ValidatorException(String msg, Throwable e) {
      super(msg, e);
   }

   /**
    * @return Returns the data.
    */
   public Object getData() {
      return data;
   }

   /**
    * @param data
    *           The data to set.
    */
   public void setData(Object data) {
      this.data = data;
   }
}