package gov.va.med.fw.util.builder;

import java.util.Map;

import org.apache.commons.lang.StringUtils;

/**
 * Gets the value from a key. The map of key value data should be in the configuration file.
 * 
 *  
 * @author Rajiv Patnaik
 * Created on Mar 31, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class MappedDataBuilder extends AbstractBuilder 
{
    private static final long serialVersionUID = 2085731226496005874L;

    private Map codeMap;
    
    private boolean partialMapping = false;

    /**
     * Default contructor.
     */
    public MappedDataBuilder()
    {
        super();
    }

    public Map getCodeMap()
    {
        return this.codeMap;
    }

    public void setCodeMap(Map codeMap)
    {
        this.codeMap = codeMap;
    }


    /**
     * Method to build(translate) a lookup code.
     * 
     * @param lookupCode
     *           The ESR lookup code to be translated to HL7 lookup code.
     * @return HL7 lookup code.
     */
    public String build(String lookupCode) throws BuilderException
    {
        if(lookupCode == null)
        {
            return null;
        }

        String val = (String) this.codeMap.get(lookupCode);
        if(StringUtils.isBlank(val) && partialMapping)
        	val = lookupCode;
        return val;
    }

	/**
	 * @return Returns the partialMapping.
	 */
	public boolean isPartialMapping() {
		return partialMapping;
	}

	/**
	 * @param partialMapping The partialMapping to set.
	 */
	public void setPartialMapping(boolean partialMapping) {
		this.partialMapping = partialMapping;
	}
}
