/********************************************************************
 Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util.builder;

// Java Classes
import java.io.Serializable;

/** Provides a generic interface to encapsulate how an object is built from a 
 * specific input data. This interface uses a Formatter and Validator interface 
 * to format data and to validate data before constructing an object.
 *
 * @author Vu Le
 * @version 1.0
 * @since 1.0
 */
public interface Builder extends Serializable {
   
   /** Constructs an object from a specific input data.  A concrete implementation will
    * need to cast input data to a specific class type that contains data for
    * constructing an object.
    * @param input Data from which an object is created
    * @throws BuilderException Thrown if failed to construct an object
    * @return Object a constructed object
    */   
	public Object build( Object input ) throws BuilderException;
}