// Package 
package gov.va.med.fw.util;

/**
 * A runtime exception that indicates that something has timed out.
 *
 * @author Andrew Pach
 */
public class TimeoutException extends RuntimeException
{
    private static final long serialVersionUID = -2443981639378057134L;

    /**
     * Default constructor.
     */
    public TimeoutException()
    {
        super();
    }

    /**
     * Constructs a <code>TimeoutException</code> with the specified detail message.
     *
     * @param msg the detail message.
     */
    public TimeoutException(String msg)
    {
        super(msg);
    }

    /**
     * Constructs a <code>TimeoutException</code> with the specified detail message and a caused exception.
     *
     * @param msg the detail message.
     * @param cause the caused exception
     */
    public TimeoutException(String msg, Throwable cause)
    {
        super(msg, cause);
    }
}
